/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public interface SuspensionState {
    public static final SuspensionState ACTIVE = new SuspensionStateImpl(1, "active");
    public static final SuspensionState SUSPENDED = new SuspensionStateImpl(2, "suspended");

    public int getStateCode();

    public static class SuspensionStateUtil {
        public static void setSuspensionState(ProcessDefinitionEntity processDefinitionEntity, SuspensionState state) {
            if (processDefinitionEntity.getSuspensionState() == state.getStateCode()) {
                throw new ActivitiException("Cannot set suspension state '" + state + "' for " + processDefinitionEntity + "': already in state '" + state + "'.");
            }
            processDefinitionEntity.setSuspensionState(state.getStateCode());
            SuspensionStateUtil.dispatchStateChangeEvent(processDefinitionEntity, state);
        }

        public static void setSuspensionState(ExecutionEntity executionEntity, SuspensionState state) {
            if (executionEntity.getSuspensionState() == state.getStateCode()) {
                throw new ActivitiException("Cannot set suspension state '" + state + "' for " + executionEntity + "': already in state '" + state + "'.");
            }
            executionEntity.setSuspensionState(state.getStateCode());
            SuspensionStateUtil.dispatchStateChangeEvent(executionEntity, state);
        }

        public static void setSuspensionState(TaskEntity taskEntity, SuspensionState state) {
            if (taskEntity.getSuspensionState() == state.getStateCode()) {
                throw new ActivitiException("Cannot set suspension state '" + state + "' for " + taskEntity + "': already in state '" + state + "'.");
            }
            taskEntity.setSuspensionState(state.getStateCode());
            SuspensionStateUtil.dispatchStateChangeEvent(taskEntity, state);
        }

        protected static void dispatchStateChangeEvent(Object entity, SuspensionState state) {
            if (Context.getCommandContext() != null && Context.getCommandContext().getEventDispatcher().isEnabled()) {
                ActivitiEventType eventType = null;
                eventType = state == ACTIVE ? ActivitiEventType.ENTITY_ACTIVATED : ActivitiEventType.ENTITY_SUSPENDED;
                Context.getCommandContext().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(eventType, entity));
            }
        }
    }

    public static class SuspensionStateImpl
    implements SuspensionState {
        public final int stateCode;
        protected final String name;

        public SuspensionStateImpl(int suspensionCode, String string) {
            this.stateCode = suspensionCode;
            this.name = string;
        }

        @Override
        public int getStateCode() {
            return this.stateCode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.stateCode;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SuspensionStateImpl other = (SuspensionStateImpl)obj;
            return this.stateCode == other.stateCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

