/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.scripting;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.scripting.ScriptingEngines;

public class ScriptCondition
implements Condition {
    private final String expression;
    private final String language;

    public ScriptCondition(String expression, String language) {
        this.expression = expression;
        this.language = language;
    }

    @Override
    public boolean evaluate(String sequenceFlowId, DelegateExecution execution) {
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        Object result = scriptingEngines.evaluate(this.expression, this.language, execution);
        if (result == null) {
            throw new ActivitiException("condition script returns null: " + this.expression);
        }
        if (!(result instanceof Boolean)) {
            throw new ActivitiException("condition script returns non-Boolean: " + result + " (" + result.getClass().getName() + ")");
        }
        return (Boolean)result;
    }
}

