/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.runtime.Execution;

public class GetExecutionVariableInstanceCmd
implements Command<VariableInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String variableName;
    protected boolean isLocal;

    public GetExecutionVariableInstanceCmd(String executionId, String variableName, boolean isLocal) {
        this.executionId = executionId;
        this.variableName = variableName;
        this.isLocal = isLocal;
    }

    @Override
    public VariableInstance execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("executionId is null");
        }
        if (this.variableName == null) {
            throw new ActivitiIllegalArgumentException("variableName is null");
        }
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        VariableInstance variableEntity = null;
        if (Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            variableEntity = activiti5CompatibilityHandler.getExecutionVariableInstance(this.executionId, this.variableName, this.isLocal);
        } else {
            variableEntity = this.isLocal ? execution.getVariableInstanceLocal(this.variableName, false) : execution.getVariableInstance(this.variableName, false);
        }
        if (variableEntity != null) {
            variableEntity.getValue();
        }
        return variableEntity;
    }
}

