/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.agenda;

import java.util.LinkedList;
import org.activiti.engine.ActivitiEngineAgenda;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.impl.agenda.ContinueMultiInstanceOperation;
import org.activiti.engine.impl.agenda.ContinueProcessOperation;
import org.activiti.engine.impl.agenda.DestroyScopeOperation;
import org.activiti.engine.impl.agenda.EndExecutionOperation;
import org.activiti.engine.impl.agenda.ExecuteInactiveBehaviorsOperation;
import org.activiti.engine.impl.agenda.TakeOutgoingSequenceFlowsOperation;
import org.activiti.engine.impl.agenda.TriggerExecutionOperation;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultActivitiEngineAgenda
implements ActivitiEngineAgenda {
    private static final Logger logger = LoggerFactory.getLogger(DefaultActivitiEngineAgenda.class);
    protected LinkedList<Runnable> operations = new LinkedList();
    protected CommandContext commandContext;

    public DefaultActivitiEngineAgenda(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    @Override
    public boolean isEmpty() {
        return this.operations.isEmpty();
    }

    @Override
    public Runnable getNextOperation() {
        return this.operations.poll();
    }

    @Override
    public void planOperation(Runnable operation) {
        ExecutionEntity execution;
        this.operations.add(operation);
        if (operation instanceof AbstractOperation && (execution = ((AbstractOperation)operation).getExecution()) != null) {
            this.commandContext.addInvolvedExecution(execution);
        }
        logger.debug("Operation {} added to agenda", operation.getClass());
    }

    @Override
    public void planContinueProcessOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution));
    }

    @Override
    public void planContinueProcessSynchronousOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution, true, false));
    }

    @Override
    public void planContinueProcessInCompensation(ExecutionEntity execution) {
        this.planOperation(new ContinueProcessOperation(this.commandContext, execution, false, true));
    }

    @Override
    public void planContinueMultiInstanceOperation(ExecutionEntity execution) {
        this.planOperation(new ContinueMultiInstanceOperation(this.commandContext, execution));
    }

    @Override
    public void planTakeOutgoingSequenceFlowsOperation(ExecutionEntity execution, boolean evaluateConditions) {
        this.planOperation(new TakeOutgoingSequenceFlowsOperation(this.commandContext, execution, evaluateConditions));
    }

    @Override
    public void planEndExecutionOperation(ExecutionEntity execution) {
        this.planOperation(new EndExecutionOperation(this.commandContext, execution));
    }

    @Override
    public void planTriggerExecutionOperation(ExecutionEntity execution) {
        this.planOperation(new TriggerExecutionOperation(this.commandContext, execution));
    }

    @Override
    public void planDestroyScopeOperation(ExecutionEntity execution) {
        this.planOperation(new DestroyScopeOperation(this.commandContext, execution));
    }

    @Override
    public void planExecuteInactiveBehaviorsOperation() {
        this.planOperation(new ExecuteInactiveBehaviorsOperation(this.commandContext));
    }
}

