/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.data.DataManager;
import org.activiti.engine.impl.persistence.entity.data.HistoricTaskInstanceDataManager;

public class HistoricTaskInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricTaskInstanceEntity>
implements HistoricTaskInstanceEntityManager {
    protected HistoricTaskInstanceDataManager historicTaskInstanceDataManager;

    public HistoricTaskInstanceEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, HistoricTaskInstanceDataManager historicTaskInstanceDataManager) {
        super(processEngineConfiguration);
        this.historicTaskInstanceDataManager = historicTaskInstanceDataManager;
    }

    @Override
    protected DataManager<HistoricTaskInstanceEntity> getDataManager() {
        return this.historicTaskInstanceDataManager;
    }

    @Override
    public HistoricTaskInstanceEntity create(TaskEntity task, ExecutionEntity execution) {
        return this.historicTaskInstanceDataManager.create(task, execution);
    }

    @Override
    public void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            List<HistoricTaskInstanceEntity> taskInstances = this.historicTaskInstanceDataManager.findHistoricTaskInstanceByProcessInstanceId(processInstanceId);
            for (HistoricTaskInstanceEntity historicTaskInstanceEntity : taskInstances) {
                this.delete(historicTaskInstanceEntity.getId());
            }
        }
    }

    @Override
    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicTaskInstanceDataManager.findHistoricTaskInstanceCountByQueryCriteria(historicTaskInstanceQuery);
        }
        return 0L;
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicTaskInstanceDataManager.findHistoricTaskInstancesByQueryCriteria(historicTaskInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesAndVariablesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.historicTaskInstanceDataManager.findHistoricTaskInstancesAndVariablesByQueryCriteria(historicTaskInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void delete(String id) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.getHistoryManager().isHistoryEnabled() && (historicTaskInstance = (HistoricTaskInstanceEntity)this.findById(id)) != null) {
            List<HistoricTaskInstanceEntity> subTasks = this.historicTaskInstanceDataManager.findHistoricTasksByParentTaskId(historicTaskInstance.getId());
            for (HistoricTaskInstance historicTaskInstance2 : subTasks) {
                this.delete(historicTaskInstance2.getId());
            }
            this.getHistoricDetailEntityManager().deleteHistoricDetailsByTaskId(id);
            this.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstancesByTaskId(id);
            this.getCommentEntityManager().deleteCommentsByTaskId(id);
            this.getAttachmentEntityManager().deleteAttachmentsByTaskId(id);
            this.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByTaskId(id);
            this.delete(historicTaskInstance);
        }
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.historicTaskInstanceDataManager.findHistoricTaskInstancesByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long findHistoricTaskInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.historicTaskInstanceDataManager.findHistoricTaskInstanceCountByNativeQuery(parameterMap);
    }

    public HistoricTaskInstanceDataManager getHistoricTaskInstanceDataManager() {
        return this.historicTaskInstanceDataManager;
    }

    public void setHistoricTaskInstanceDataManager(HistoricTaskInstanceDataManager historicTaskInstanceDataManager) {
        this.historicTaskInstanceDataManager = historicTaskInstanceDataManager;
    }
}

