/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class ProcessInstanceHelper {
    public ProcessInstance createProcessInstance(ProcessDefinitionEntity processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables) {
        return this.createAndStartProcessInstance(processDefinition, businessKey, processInstanceName, variables, transientVariables, false);
    }

    public ProcessInstance createAndStartProcessInstance(ProcessDefinition processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables) {
        return this.createAndStartProcessInstance(processDefinition, businessKey, processInstanceName, variables, transientVariables, true);
    }

    protected ProcessInstance createAndStartProcessInstance(ProcessDefinition processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables, boolean startProcessInstance) {
        CommandContext commandContext = Context.getCommandContext();
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (process == null) {
            throw new ActivitiException("Cannot start process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = process.getInitialFlowElement();
        if (initialFlowElement == null) {
            throw new ActivitiException("No start element found for process definition " + processDefinition.getId());
        }
        return this.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, processInstanceName, initialFlowElement, process, variables, transientVariables, startProcessInstance);
    }

    public ProcessInstance createAndStartProcessInstanceByMessage(ProcessDefinition processDefinition, String businessKey, String messageName, Map<String, Object> messageVariables, Map<String, Object> transientVariables, MessageEventSubscriptionEntity eventSubscription) {
        CommandContext commandContext = Context.getCommandContext();
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new ActivitiException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (process == null) {
            throw new ActivitiException("Cannot start process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = null;
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinition.getId());
        for (FlowElement flowElement : process.getFlowElements()) {
            StartEvent startEvent;
            if (!(flowElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof MessageEventDefinition)) continue;
            MessageEventDefinition messageEventDefinition = (MessageEventDefinition)startEvent.getEventDefinitions().get(0);
            String messageRef = messageEventDefinition.getMessageRef();
            if (messageRef.equals(messageName)) {
                initialFlowElement = flowElement;
                break;
            }
            if (!bpmnModel.containsMessageId(messageRef)) continue;
            Message message = bpmnModel.getMessage(messageRef);
            messageEventDefinition.setMessageRef(message.getName());
            initialFlowElement = flowElement;
            break;
        }
        if (initialFlowElement == null) {
            throw new ActivitiException("No message start event found for process definition " + processDefinition.getId() + " and message name " + messageName);
        }
        Map processVariables = (Map)commandContext.getProcessEngineConfiguration().getEventSubscriptionPayloadMappingProvider().apply(messageVariables, eventSubscription);
        ExecutionEntity processInstance = this.createProcessInstanceWithInitialFlowElement(processDefinition, businessKey, null, initialFlowElement, process, processVariables, transientVariables);
        this.dispatchStartMessageReceivedEvent(processInstance, messageName, messageVariables);
        this.startProcessInstance(processInstance, commandContext, processVariables);
        return processInstance;
    }

    public ProcessInstance createAndStartProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String processInstanceName, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables, boolean startProcessInstance) {
        ExecutionEntity processInstance = this.createProcessInstanceWithInitialFlowElement(processDefinition, businessKey, processInstanceName, initialFlowElement, process, variables, transientVariables);
        if (startProcessInstance) {
            CommandContext commandContext = Context.getCommandContext();
            this.startProcessInstance(processInstance, commandContext, variables);
        }
        return processInstance;
    }

    public void startProcessInstance(ExecutionEntity processInstance, CommandContext commandContext, Map<String, Object> variables) {
        Process process = ProcessDefinitionUtil.getProcess(processInstance.getProcessDefinitionId());
        LinkedList<MessageEventSubscriptionEntity> messageEventSubscriptions = new LinkedList<MessageEventSubscriptionEntity>();
        for (FlowElement flowElement : process.getFlowElements()) {
            if (!(flowElement instanceof EventSubProcess)) continue;
            EventSubProcess eventSubProcess = (EventSubProcess)flowElement;
            for (FlowElement subElement : eventSubProcess.getFlowElements()) {
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(subElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((startEvent = (StartEvent)subElement).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof MessageEventDefinition)) continue;
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processInstance.getProcessDefinitionId());
                if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
                    messageEventDefinition.setMessageRef(bpmnModel.getMessage(messageEventDefinition.getMessageRef()).getName());
                }
                ExecutionEntity messageExecution = commandContext.getExecutionEntityManager().createChildExecution(processInstance);
                messageExecution.setCurrentFlowElement((FlowElement)startEvent);
                messageExecution.setEventScope(true);
                String messageName = this.getMessageName(commandContext, messageEventDefinition, messageExecution);
                MessageEventSubscriptionEntity subscription = commandContext.getEventSubscriptionEntityManager().insertMessageEvent(messageName, messageExecution);
                Optional<String> correlationKey = this.getCorrelationKey(commandContext, messageEventDefinition, messageExecution);
                correlationKey.ifPresent(subscription::setConfiguration);
                messageEventSubscriptions.add(subscription);
            }
        }
        ExecutionEntity execution = processInstance.getExecutions().get(0);
        commandContext.getAgenda().planContinueProcessOperation(execution);
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createProcessStartedEvent(execution, variables, false));
            for (MessageEventSubscriptionEntity messageEventSubscription : messageEventSubscriptions) {
                commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createMessageWaitingEvent(messageEventSubscription.getExecution(), messageEventSubscription.getEventName(), messageEventSubscription.getConfiguration()));
            }
        }
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    protected Optional<String> getCorrelationKey(CommandContext commandContext, MessageEventDefinition messageEventDefinition, DelegateExecution execution) {
        ExpressionManager expressionManager = commandContext.getProcessEngineConfiguration().getExpressionManager();
        return Optional.ofNullable(messageEventDefinition.getCorrelationKey()).map(correlationKey -> {
            Expression expression = expressionManager.createExpression(messageEventDefinition.getCorrelationKey());
            return expression.getValue(execution).toString();
        });
    }

    protected String getMessageName(CommandContext commandContext, MessageEventDefinition messageEventDefinition, DelegateExecution execution) {
        ExpressionManager expressionManager = commandContext.getProcessEngineConfiguration().getExpressionManager();
        String messageName = Optional.ofNullable(messageEventDefinition.getMessageRef()).orElse(messageEventDefinition.getMessageExpression());
        Expression expression = expressionManager.createExpression(messageName);
        return expression.getValue(execution).toString();
    }

    public ExecutionEntity createProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String processInstanceName, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables) {
        CommandContext commandContext = Context.getCommandContext();
        String initiatorVariableName = null;
        if (initialFlowElement instanceof StartEvent) {
            initiatorVariableName = ((StartEvent)initialFlowElement).getInitiator();
        }
        ExecutionEntity processInstance = commandContext.getExecutionEntityManager().createProcessInstanceExecution(processDefinition, businessKey, processDefinition.getTenantId(), initiatorVariableName);
        commandContext.getHistoryManager().recordProcessInstanceStart(processInstance, initialFlowElement);
        processInstance.setVariables(this.processDataObjects(process.getDataObjects()));
        if (variables != null) {
            for (String varName : variables.keySet()) {
                processInstance.setVariable(varName, variables.get(varName));
            }
        }
        if (transientVariables != null) {
            for (String varName : transientVariables.keySet()) {
                processInstance.setTransientVariable(varName, transientVariables.get(varName));
            }
        }
        if (processInstanceName != null) {
            processInstance.setName(processInstanceName);
            commandContext.getHistoryManager().recordProcessInstanceNameChange(processInstance.getId(), processInstanceName);
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityWithVariablesEvent(ActivitiEventType.ENTITY_INITIALIZED, processInstance, variables, false));
        }
        ExecutionEntity execution = commandContext.getExecutionEntityManager().createChildExecution(processInstance);
        execution.setCurrentFlowElement(initialFlowElement);
        return processInstance;
    }

    protected void dispatchStartMessageReceivedEvent(ExecutionEntity processInstance, String messageName, Map<String, Object> variables) {
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            DelegateExecution execution = processInstance.getExecutions().get(0);
            ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createMessageReceivedEvent(execution, messageName, null, variables));
        }
    }
}

