/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;

public class SequentialMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public SequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution multiInstanceExecution) {
        int nrOfInstances = this.resolveNrOfInstances(multiInstanceExecution);
        if (nrOfInstances == 0) {
            return nrOfInstances;
        }
        if (nrOfInstances < 0) {
            throw new ActivitiIllegalArgumentException("Invalid number of instances: must be a non-negative integer value, but was " + nrOfInstances);
        }
        ExecutionEntity childExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)multiInstanceExecution);
        childExecution.setCurrentFlowElement(multiInstanceExecution.getCurrentFlowElement());
        multiInstanceExecution.setMultiInstanceRoot(true);
        multiInstanceExecution.setActive(false);
        this.setLoopVariable(multiInstanceExecution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(multiInstanceExecution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(multiInstanceExecution, "nrOfActiveInstances", 1);
        this.setLoopVariable(childExecution, this.getCollectionElementIndexVariable(), 0);
        this.logLoopDetails(multiInstanceExecution, "initialized", 0, 0, 1, nrOfInstances);
        this.executeOriginalBehavior(childExecution, 0);
        return nrOfInstances;
    }

    @Override
    public void leave(DelegateExecution childExecution) {
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(childExecution);
        int nrOfInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfInstances");
        int loopCounter = this.getLoopVariable(childExecution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfCompletedInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances");
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.setLoopVariable(childExecution, this.getCollectionElementIndexVariable(), loopCounter);
        this.logLoopDetails(childExecution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        this.updateResultCollection(childExecution, multiInstanceRootExecution);
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)childExecution, null);
        this.callActivityEndListeners(childExecution);
        if (loopCounter >= nrOfInstances || this.completionConditionSatisfied(multiInstanceRootExecution)) {
            this.propagateLoopDataOutputRefToProcessInstance((ExecutionEntity)multiInstanceRootExecution);
            this.removeLocalLoopVariable(childExecution, this.getCollectionElementIndexVariable());
            multiInstanceRootExecution.setMultiInstanceRoot(false);
            multiInstanceRootExecution.setScope(false);
            multiInstanceRootExecution.setCurrentFlowElement(childExecution.getCurrentFlowElement());
            Context.getCommandContext().getExecutionEntityManager().deleteChildExecutions((ExecutionEntity)multiInstanceRootExecution, "MI_END");
            this.dispatchActivityCompletedEvent(childExecution);
            super.leave(multiInstanceRootExecution);
        } else {
            try {
                if (childExecution.getCurrentFlowElement() instanceof SubProcess) {
                    ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
                    ExecutionEntity executionToContinue = executionEntityManager.createChildExecution((ExecutionEntity)multiInstanceRootExecution);
                    executionToContinue.setCurrentFlowElement(childExecution.getCurrentFlowElement());
                    executionToContinue.setScope(true);
                    this.setLoopVariable(executionToContinue, this.getCollectionElementIndexVariable(), loopCounter);
                    this.executeOriginalBehavior(executionToContinue, loopCounter);
                } else {
                    this.executeOriginalBehavior(childExecution, loopCounter);
                }
                this.dispatchActivityCompletedEvent(childExecution);
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new ActivitiException("Could not execute inner activity behavior of multi instance behavior", e);
            }
        }
    }
}

