/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.bpmn.model.AdhocSubProcess;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;

public class CompleteAdhocSubProcessCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;

    public CompleteAdhocSubProcessCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(this.executionId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("No execution found for id '" + this.executionId + "'", ExecutionEntity.class);
        }
        if (!(execution.getCurrentFlowElement() instanceof AdhocSubProcess)) {
            throw new ActivitiException("The current flow element of the requested execution is not an ad-hoc sub process");
        }
        List<? extends ExecutionEntity> childExecutions = execution.getExecutions();
        if (childExecutions.size() > 0) {
            throw new ActivitiException("Ad-hoc sub process has running child executions that need to be completed first");
        }
        ExecutionEntity outgoingFlowExecution = executionEntityManager.createChildExecution(execution.getParent());
        outgoingFlowExecution.setCurrentFlowElement(execution.getCurrentFlowElement());
        executionEntityManager.deleteExecutionAndRelatedData(execution, null);
        Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(outgoingFlowExecution, true);
        return null;
    }
}

