/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.impl.cmd.AbstractCompleteTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class CompleteTaskCmd
extends AbstractCompleteTaskCmd {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected Map<String, Object> taskVariables;
    protected boolean localScope;

    public CompleteTaskCmd(String taskId, Map<String, Object> variables) {
        super(taskId);
        this.variables = variables;
    }

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, boolean localScope) {
        this(taskId, variables);
        this.localScope = localScope;
    }

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, variables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (this.variables != null) {
            if (this.localScope) {
                task.setVariablesLocal(this.variables);
            } else if (task.getExecutionId() != null) {
                task.setExecutionVariables(this.variables);
            } else {
                task.setVariables(this.variables);
            }
        }
        if (this.transientVariables != null) {
            if (this.localScope) {
                task.setTransientVariablesLocal(this.transientVariables);
            } else {
                task.setTransientVariables(this.transientVariables);
            }
        }
        this.setTaskVariables(task.getVariablesLocal());
        this.executeTaskComplete(commandContext, task, this.variables, this.localScope);
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot complete a suspended task";
    }

    public Map<String, Object> getTaskVariables() {
        return this.taskVariables;
    }

    private void setTaskVariables(Map<String, Object> taskVariables) {
        this.taskVariables = taskVariables;
    }
}

