/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event;

import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.event.AbstractEventHandler;
import org.activiti.engine.impl.event.EventSubscriptionPayloadMappingProvider;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class MessageEventHandler
extends AbstractEventHandler {
    public static final String EVENT_HANDLER_TYPE = "message";
    private final EventSubscriptionPayloadMappingProvider messageEventVariableMappingProvider;

    public MessageEventHandler(EventSubscriptionPayloadMappingProvider messageEventVariableMappingProvider) {
        this.messageEventVariableMappingProvider = messageEventVariableMappingProvider;
    }

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            ExecutionEntity execution = eventSubscription.getExecution();
            String messageName = eventSubscription.getEventName();
            String correlationKey = eventSubscription.getConfiguration();
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createMessageReceivedEvent(execution, messageName, correlationKey, payload));
        }
        Object variables = this.messageEventVariableMappingProvider.apply(payload, eventSubscription);
        super.handleEvent(eventSubscription, variables, commandContext);
    }
}

