/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.CountingExecutionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.impl.persistence.entity.VariableInitializingList;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;

public class ExecutionEntityImpl
extends VariableScopeImpl
implements ExecutionEntity,
CountingExecutionEntity {
    private static final long serialVersionUID = 1L;
    protected FlowElement currentFlowElement;
    protected ActivitiListener currentActivitiListener;
    protected ExecutionEntityImpl processInstance;
    protected ExecutionEntityImpl parent;
    protected List<ExecutionEntityImpl> executions;
    protected ExecutionEntityImpl superExecution;
    protected ExecutionEntityImpl subProcessInstance;
    protected String tenantId = "";
    protected String name;
    protected String description;
    protected String localizedName;
    protected String localizedDescription;
    protected Date lockTime;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent;
    protected boolean isEnded;
    protected boolean isEventScope;
    protected boolean isMultiInstanceRoot;
    protected boolean isCountEnabled;
    protected String eventName;
    protected List<EventSubscriptionEntity> eventSubscriptions;
    protected List<JobEntity> jobs;
    protected List<TimerJobEntity> timerJobs;
    protected List<TaskEntity> tasks;
    protected List<IdentityLinkEntity> identityLinks;
    protected String deleteReason;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String startUserId;
    protected Date startTime;
    protected int eventSubscriptionCount;
    protected int taskCount;
    protected int jobCount;
    protected int timerJobCount;
    protected int suspendedJobCount;
    protected int deadLetterJobCount;
    protected int variableCount;
    protected int identityLinkCount;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionName;
    protected Integer processDefinitionVersion;
    protected String deploymentId;
    protected String activityId;
    protected String activityName;
    protected String processInstanceId;
    protected String businessKey;
    protected String parentId;
    protected String superExecutionId;
    protected String rootProcessInstanceId;
    protected ExecutionEntityImpl rootProcessInstance;
    protected boolean forcedUpdate;
    protected List<VariableInstanceEntity> queryVariables;
    protected boolean isDeleted;
    protected String parentProcessInstanceId;
    private Integer appVersion;

    public static ExecutionEntityImpl createWithEmptyRelationshipCollections() {
        ExecutionEntityImpl execution = new ExecutionEntityImpl();
        execution.executions = new ArrayList<ExecutionEntityImpl>(1);
        execution.tasks = new ArrayList<TaskEntity>(1);
        execution.variableInstances = new HashMap(1);
        execution.jobs = new ArrayList<JobEntity>(1);
        execution.timerJobs = new ArrayList<TimerJobEntity>(1);
        execution.eventSubscriptions = new ArrayList<EventSubscriptionEntity>(1);
        execution.identityLinks = new ArrayList<IdentityLinkEntity>(1);
        return execution;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("isActive", this.isActive);
        persistentState.put("isConcurrent", this.isConcurrent);
        persistentState.put("isScope", this.isScope);
        persistentState.put("isEventScope", this.isEventScope);
        persistentState.put("parentId", this.parentId);
        persistentState.put("name", this.name);
        persistentState.put("lockTime", this.lockTime);
        persistentState.put("superExecution", this.superExecutionId);
        persistentState.put("rootProcessInstanceId", this.rootProcessInstanceId);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("startTime", this.startTime);
        persistentState.put("startUserId", this.startUserId);
        persistentState.put("eventSubscriptionCount", this.eventSubscriptionCount);
        persistentState.put("taskCount", this.taskCount);
        persistentState.put("jobCount", this.jobCount);
        persistentState.put("timerJobCount", this.timerJobCount);
        persistentState.put("suspendedJobCount", this.suspendedJobCount);
        persistentState.put("deadLetterJobCount", this.deadLetterJobCount);
        persistentState.put("variableCount", this.variableCount);
        persistentState.put("identityLinkCount", this.identityLinkCount);
        return persistentState;
    }

    @Override
    public FlowElement getCurrentFlowElement() {
        String processDefinitionId;
        if (this.currentFlowElement == null && (processDefinitionId = this.getProcessDefinitionId()) != null) {
            Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
            this.currentFlowElement = process.getFlowElement(this.getCurrentActivityId(), true);
        }
        return this.currentFlowElement;
    }

    @Override
    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
        this.activityId = currentFlowElement != null ? currentFlowElement.getId() : null;
    }

    @Override
    public ActivitiListener getCurrentActivitiListener() {
        return this.currentActivitiListener;
    }

    @Override
    public void setCurrentActivitiListener(ActivitiListener currentActivitiListener) {
        this.currentActivitiListener = currentActivitiListener;
    }

    public List<ExecutionEntityImpl> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    @Override
    public void addChildExecution(ExecutionEntity executionEntity) {
        this.ensureExecutionsInitialized();
        this.executions.add((ExecutionEntityImpl)executionEntity);
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            this.executions = Context.getCommandContext().getExecutionEntityManager().findChildExecutionsByParentExecutionId(this.id);
        }
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getProcessInstanceBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    @Override
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @Override
    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public ExecutionEntityImpl getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.processInstanceId);
        }
    }

    @Override
    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = (ExecutionEntityImpl)processInstance;
        if (processInstance != null) {
            this.processInstanceId = this.processInstance.getId();
        }
    }

    @Override
    public boolean isProcessInstanceType() {
        return this.parentId == null;
    }

    @Override
    public ExecutionEntityImpl getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            this.parent = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.parentId);
        }
    }

    @Override
    public void setParent(ExecutionEntity parent) {
        this.parent = (ExecutionEntityImpl)parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    @Override
    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    @Override
    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    @Override
    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    @Override
    public ExecutionEntityImpl getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(ExecutionEntity superExecution) {
        this.superExecution = (ExecutionEntityImpl)superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
        if (superExecution != null) {
            this.superExecutionId = ((ExecutionEntityImpl)superExecution).getId();
            this.parentProcessInstanceId = superExecution.getProcessInstanceId();
        } else {
            this.superExecutionId = null;
            this.parentProcessInstanceId = null;
        }
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntityImpl getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(ExecutionEntity subProcessInstance) {
        this.subProcessInstance = (ExecutionEntityImpl)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(this.id);
        }
    }

    @Override
    public ExecutionEntity getRootProcessInstance() {
        this.ensureRootProcessInstanceInitialized();
        return this.rootProcessInstance;
    }

    protected void ensureRootProcessInstanceInitialized() {
        if (this.rootProcessInstanceId == null) {
            this.rootProcessInstance = (ExecutionEntityImpl)Context.getCommandContext().getExecutionEntityManager().findById(this.rootProcessInstanceId);
        }
    }

    @Override
    public void setRootProcessInstance(ExecutionEntity rootProcessInstance) {
        this.rootProcessInstance = (ExecutionEntityImpl)rootProcessInstance;
        this.rootProcessInstanceId = rootProcessInstance != null ? rootProcessInstance.getId() : null;
    }

    @Override
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    @Override
    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        if (this.processInstanceId != null) {
            variableInstance.setProcessInstanceId(this.processInstanceId);
        } else {
            variableInstance.setProcessInstanceId(this.id);
        }
        variableInstance.setExecutionId(this.id);
    }

    @Override
    protected Collection<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceEntityManager().findVariableInstancesByExecutionId(this.id);
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        return this.getParent();
    }

    @Override
    protected ExecutionEntityImpl getSourceActivityExecution() {
        return this;
    }

    @Override
    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableInstanceEntity result = super.createVariableInstance(variableName, value, sourceActivityExecution);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createVariableEvent(ActivitiEventType.VARIABLE_CREATED, variableName, value, result.getType(), result.getTaskId(), result.getExecutionId(), this.getProcessInstanceId(), this.getProcessDefinitionId()));
        }
        return result;
    }

    @Override
    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        super.updateVariableInstance(variableInstance, value, sourceActivityExecution);
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createVariableEvent(ActivitiEventType.VARIABLE_UPDATED, variableInstance.getName(), value, variableInstance.getType(), variableInstance.getTaskId(), variableInstance.getExecutionId(), this.getProcessInstanceId(), this.getProcessDefinitionId()));
        }
    }

    @Override
    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new ActivitiException("lazy loading outside command context");
        }
        VariableInstanceEntity variableInstance = commandContext.getVariableInstanceEntityManager().findVariableInstanceByExecutionAndName(this.id, variableName);
        return variableInstance;
    }

    @Override
    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new ActivitiException("lazy loading outside command context");
        }
        return commandContext.getVariableInstanceEntityManager().findVariableInstancesByExecutionAndNames(this.id, variableNames);
    }

    @Override
    public List<EventSubscriptionEntity> getEventSubscriptions() {
        this.ensureEventSubscriptionsInitialized();
        return this.eventSubscriptions;
    }

    protected void ensureEventSubscriptionsInitialized() {
        if (this.eventSubscriptions == null) {
            this.eventSubscriptions = Context.getCommandContext().getEventSubscriptionEntityManager().findEventSubscriptionsByExecution(this.id);
        }
    }

    @Override
    public List<JobEntity> getJobs() {
        this.ensureJobsInitialized();
        return this.jobs;
    }

    protected void ensureJobsInitialized() {
        if (this.jobs == null) {
            this.jobs = Context.getCommandContext().getJobEntityManager().findJobsByExecutionId(this.id);
        }
    }

    @Override
    public List<TimerJobEntity> getTimerJobs() {
        this.ensureTimerJobsInitialized();
        return this.timerJobs;
    }

    protected void ensureTimerJobsInitialized() {
        if (this.timerJobs == null) {
            this.timerJobs = Context.getCommandContext().getTimerJobEntityManager().findJobsByExecutionId(this.id);
        }
    }

    protected void ensureTasksInitialized() {
        if (this.tasks == null) {
            this.tasks = Context.getCommandContext().getTaskEntityManager().findTasksByExecutionId(this.id);
        }
    }

    @Override
    public List<TaskEntity> getTasks() {
        this.ensureTasksInitialized();
        return this.tasks;
    }

    @Override
    public List<IdentityLinkEntity> getIdentityLinks() {
        this.ensureIdentityLinksInitialized();
        return this.identityLinks;
    }

    protected void ensureIdentityLinksInitialized() {
        if (this.identityLinks == null) {
            this.identityLinks = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByProcessInstanceId(this.id);
        }
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public void setEnded(boolean isEnded) {
        this.isEnded = isEnded;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    @Override
    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public int getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isEventScope() {
        return this.isEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    @Override
    public boolean isMultiInstanceRoot() {
        return this.isMultiInstanceRoot;
    }

    @Override
    public void setMultiInstanceRoot(boolean isMultiInstanceRoot) {
        this.isMultiInstanceRoot = isMultiInstanceRoot;
    }

    @Override
    public boolean isCountEnabled() {
        return this.isCountEnabled;
    }

    @Override
    public void setCountEnabled(boolean isCountEnabled) {
        this.isCountEnabled = isCountEnabled;
    }

    @Override
    public String getCurrentActivityId() {
        return this.activityId;
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLocalizedName() {
        return this.localizedName;
    }

    @Override
    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    @Override
    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Date getLockTime() {
        return this.lockTime;
    }

    @Override
    public void setLockTime(Date lockTime) {
        this.lockTime = lockTime;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public String getActivityName() {
        return this.activityName;
    }

    @Override
    public String getStartUserId() {
        return this.startUserId;
    }

    @Override
    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Override
    public int getEventSubscriptionCount() {
        return this.eventSubscriptionCount;
    }

    @Override
    public void setEventSubscriptionCount(int eventSubscriptionCount) {
        this.eventSubscriptionCount = eventSubscriptionCount;
    }

    @Override
    public int getTaskCount() {
        return this.taskCount;
    }

    @Override
    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
    }

    @Override
    public int getJobCount() {
        return this.jobCount;
    }

    @Override
    public void setJobCount(int jobCount) {
        this.jobCount = jobCount;
    }

    @Override
    public int getTimerJobCount() {
        return this.timerJobCount;
    }

    @Override
    public void setTimerJobCount(int timerJobCount) {
        this.timerJobCount = timerJobCount;
    }

    @Override
    public int getSuspendedJobCount() {
        return this.suspendedJobCount;
    }

    @Override
    public void setSuspendedJobCount(int suspendedJobCount) {
        this.suspendedJobCount = suspendedJobCount;
    }

    @Override
    public int getDeadLetterJobCount() {
        return this.deadLetterJobCount;
    }

    @Override
    public void setDeadLetterJobCount(int deadLetterJobCount) {
        this.deadLetterJobCount = deadLetterJobCount;
    }

    @Override
    public int getVariableCount() {
        return this.variableCount;
    }

    @Override
    public void setVariableCount(int variableCount) {
        this.variableCount = variableCount;
    }

    @Override
    public int getIdentityLinkCount() {
        return this.identityLinkCount;
    }

    @Override
    public void setIdentityLinkCount(int identityLinkCount) {
        this.identityLinkCount = identityLinkCount;
    }

    @Override
    public void setAppVersion(Integer appVersion) {
        this.appVersion = appVersion;
    }

    @Override
    public Integer getAppVersion() {
        return this.appVersion;
    }

    public String toString() {
        if (this.isProcessInstanceType()) {
            return "ProcessInstance[" + this.getId() + "]";
        }
        StringBuilder strb = new StringBuilder();
        if (this.isScope) {
            strb.append("Scoped execution[ id '" + this.getId() + "' ]");
        } else if (this.isMultiInstanceRoot) {
            strb.append("Multi instance root execution[ id '" + this.getId() + "' ]");
        } else {
            strb.append("Execution[ id '" + this.getId() + "' ]");
        }
        if (this.activityId != null) {
            strb.append(" - activity '" + this.activityId);
        }
        if (this.parentId != null) {
            strb.append(" - parent '" + this.parentId + "'");
        }
        return strb.toString();
    }
}

