/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.form;

import java.util.HashMap;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.form.FormData;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.form.FormDataResponse;
import org.activiti.rest.service.api.form.RestFormProperty;
import org.activiti.rest.service.api.form.SubmitFormRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class FormDataResource
extends SecuredResource {
    @Get
    public FormDataResponse getFormData() {
        if (!this.authenticate()) {
            return null;
        }
        Form urlQuery = this.getQuery();
        String taskId = this.getQueryParameter("taskId", urlQuery);
        String processDefinitionId = this.getQueryParameter("processDefinitionId", urlQuery);
        if (taskId == null && processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("The taskId or processDefinitionId parameter has to be provided");
        }
        if (taskId != null && processDefinitionId != null) {
            throw new ActivitiIllegalArgumentException("Not both a taskId and a processDefinitionId parameter can be provided");
        }
        TaskFormData formData = null;
        String id = null;
        if (taskId != null) {
            formData = ActivitiUtil.getFormService().getTaskFormData(taskId);
            id = taskId;
        } else {
            formData = ActivitiUtil.getFormService().getStartFormData(processDefinitionId);
            id = processDefinitionId;
        }
        if (formData == null) {
            throw new ActivitiObjectNotFoundException("Could not find a form data with id '" + id + "'.", FormData.class);
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createFormDataResponse(this, (FormData)formData);
    }

    @Post
    public ProcessInstanceResponse submitForm(SubmitFormRequest submitRequest) {
        if (!this.authenticate()) {
            return null;
        }
        if (submitRequest == null) {
            throw new ResourceException(new Status(Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE.getCode(), "A request body was expected when executing the form submit.", null, null));
        }
        if (submitRequest.getTaskId() == null && submitRequest.getProcessDefinitionId() == null) {
            throw new ActivitiIllegalArgumentException("The taskId or processDefinitionId property has to be provided");
        }
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (submitRequest.getProperties() != null) {
            for (RestFormProperty formProperty : submitRequest.getProperties()) {
                propertyMap.put(formProperty.getId(), formProperty.getValue());
            }
        }
        if (submitRequest.getTaskId() != null) {
            ActivitiUtil.getFormService().submitTaskFormData(submitRequest.getTaskId(), propertyMap);
            return null;
        }
        ProcessInstance processInstance = null;
        processInstance = submitRequest.getBusinessKey() != null ? ActivitiUtil.getFormService().submitStartFormData(submitRequest.getProcessDefinitionId(), submitRequest.getBusinessKey(), propertyMap) : ActivitiUtil.getFormService().submitStartFormData(submitRequest.getProcessDefinitionId(), propertyMap);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createProcessInstanceResponse(this, processInstance);
    }
}

