/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.history.HistoricProcessInstanceResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class HistoricProcessInstanceResource
extends SecuredResource {
    @Get
    public HistoricProcessInstanceResponse getProcessInstance() {
        if (!this.authenticate()) {
            return null;
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createHistoricProcessInstanceResponse(this, this.getHistoricProcessInstanceFromRequest());
    }

    @Delete
    public void deleteProcessInstance() {
        if (!this.authenticate()) {
            return;
        }
        String processInstanceId = this.getAttribute("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("The processInstanceId cannot be null");
        }
        ActivitiUtil.getHistoryService().deleteHistoricProcessInstance(processInstanceId);
    }

    protected HistoricProcessInstance getHistoricProcessInstanceFromRequest() {
        String processInstanceId = this.getAttribute("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("The processInstanceId cannot be null");
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)ActivitiUtil.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", HistoricProcessInstance.class);
        }
        return processInstance;
    }
}

