/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.history;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricVariableInstanceQuery;
import org.activiti.engine.impl.HistoricVariableInstanceQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.QueryVariable;
import org.activiti.rest.service.api.history.HistoricVariableInstancePaginateList;
import org.activiti.rest.service.api.history.HistoricVariableInstanceQueryRequest;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;

public class HistoricVariableInstanceBaseResource
extends SecuredResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();

    protected DataResponse getQueryResponse(HistoricVariableInstanceQueryRequest queryRequest, Form urlQuery) {
        HistoricVariableInstanceQuery query = ActivitiUtil.getHistoryService().createHistoricVariableInstanceQuery();
        if (queryRequest.getExcludeTaskVariables() != null && queryRequest.getExcludeTaskVariables().booleanValue()) {
            query.excludeTaskVariables();
        }
        if (queryRequest.getTaskId() != null) {
            query.taskId(queryRequest.getTaskId());
        }
        if (queryRequest.getProcessInstanceId() != null) {
            query.processInstanceId(queryRequest.getProcessInstanceId());
        }
        if (queryRequest.getVariableName() != null) {
            query.variableName(queryRequest.getVariableName());
        }
        if (queryRequest.getVariableNameLike() != null) {
            query.variableNameLike(queryRequest.getVariableNameLike());
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables());
        }
        return new HistoricVariableInstancePaginateList(this).paginateList(urlQuery, (Query)query, "variableName", allowedSortProperties);
    }

    protected void addVariables(HistoricVariableInstanceQuery variableInstanceQuery, List<QueryVariable> variables) {
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        block3: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new ActivitiIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new ActivitiIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = responseFactory.getVariableValue(variable);
            if (nameLess) {
                throw new ActivitiIllegalArgumentException("Value-only query (without a variable-name) is not supported");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    variableInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block3;
                }
            }
            throw new ActivitiIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    static {
        allowedSortProperties.put("processInstanceId", (QueryProperty)HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        allowedSortProperties.put("variableName", (QueryProperty)HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
    }
}

