/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import java.util.HashMap;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.impl.GroupQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.identity.GroupPaginateList;
import org.activiti.rest.service.api.identity.GroupRequest;
import org.activiti.rest.service.api.identity.GroupResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class GroupCollectionResource
extends SecuredResource {
    protected static HashMap<String, QueryProperty> properties = new HashMap();

    @Get
    public DataResponse getGroups() {
        if (!this.authenticate()) {
            return null;
        }
        GroupQuery query = ActivitiUtil.getIdentityService().createGroupQuery();
        Form form = this.getQuery();
        Set names = form.getNames();
        if (names.contains("id")) {
            query.groupId(this.getQueryParameter("id", form));
        }
        if (names.contains("name")) {
            query.groupName(this.getQueryParameter("name", form));
        }
        if (names.contains("nameLike")) {
            query.groupNameLike(this.getQueryParameter("nameLike", form));
        }
        if (names.contains("type")) {
            query.groupType(this.getQueryParameter("type", form));
        }
        if (names.contains("member")) {
            query.groupMember(this.getQueryParameter("member", form));
        }
        if (names.contains("potentialStarter")) {
            query.potentialStarter(this.getQueryParameter("potentialStarter", form));
        }
        return new GroupPaginateList(this).paginateList(form, (Query)query, "id", properties);
    }

    @Post
    public GroupResponse createGroup(GroupRequest request) {
        if (!this.authenticate()) {
            return null;
        }
        if (request.getId() == null) {
            throw new ActivitiIllegalArgumentException("Id cannot be null.");
        }
        if (ActivitiUtil.getIdentityService().createGroupQuery().groupId(request.getId()).count() > 0L) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT.getCode(), "A group with id '" + request.getId() + "' already exists.", null, null);
        }
        Group created = ActivitiUtil.getIdentityService().newGroup(request.getId());
        created.setId(request.getId());
        created.setName(request.getName());
        created.setType(request.getType());
        ActivitiUtil.getIdentityService().saveGroup(created);
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createGroupResponse(this, created);
    }

    static {
        properties.put("id", (QueryProperty)GroupQueryProperty.GROUP_ID);
        properties.put("name", (QueryProperty)GroupQueryProperty.NAME);
        properties.put("type", (QueryProperty)GroupQueryProperty.TYPE);
    }
}

