/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.identity.Group;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.identity.BaseGroupResource;
import org.activiti.rest.service.api.identity.GroupRequest;
import org.activiti.rest.service.api.identity.GroupResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Put;

public class GroupResource
extends BaseGroupResource {
    @Get
    public GroupResponse getUser() {
        if (!this.authenticate()) {
            return null;
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createGroupResponse(this, this.getGroupFromRequest());
    }

    @Put
    public GroupResponse updateGroup(GroupRequest request) {
        if (!this.authenticate()) {
            return null;
        }
        Group group = this.getGroupFromRequest();
        if (request.getId() == null || request.getId().equals(group.getId())) {
            if (request.isNameChanged()) {
                group.setName(request.getName());
            }
            if (request.isTypeChanged()) {
                group.setType(request.getType());
            }
        } else {
            throw new ActivitiIllegalArgumentException("Key provided in request body doesn't match the key in the resource URL.");
        }
        ActivitiUtil.getIdentityService().saveGroup(group);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createGroupResponse(this, group);
    }

    @Delete
    public void deleteGroup() {
        if (!this.authenticate()) {
            return;
        }
        Group group = this.getGroupFromRequest();
        ActivitiUtil.getIdentityService().deleteGroup(group.getId());
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

