/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.task.Attachment;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.AttachmentResponse;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.restlet.representation.Representation;
import org.restlet.resource.Put;

public class TaskUrlAddResource
extends SecuredResource {
    @Put
    public AttachmentResponse addUrl(Representation entity) {
        if (!this.authenticate()) {
            return null;
        }
        String taskId = (String)this.getRequest().getAttributes().get("taskId");
        if (taskId == null || taskId.length() == 0) {
            throw new ActivitiIllegalArgumentException("No taskId provided");
        }
        try {
            String taskParams = entity.getText();
            JsonNode taskJSON = new ObjectMapper().readTree(taskParams);
            String name = null;
            if (taskJSON.path("name") != null && taskJSON.path("name").getTextValue() != null) {
                name = taskJSON.path("name").getTextValue();
            }
            String description = null;
            if (taskJSON.path("description") != null && taskJSON.path("description").getTextValue() != null) {
                description = taskJSON.path("description").getTextValue();
            }
            String url = null;
            if (taskJSON.path("url") != null && taskJSON.path("url").getTextValue() != null) {
                url = taskJSON.path("url").getTextValue();
            }
            Attachment attachment = ActivitiUtil.getTaskService().createAttachment("url", taskId, null, name, description, url);
            return new AttachmentResponse(attachment);
        }
        catch (Exception e) {
            if (e instanceof ActivitiException) {
                throw (ActivitiException)e;
            }
            throw new ActivitiException("Unable to add new attachment to task " + taskId);
        }
    }
}

