/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.management;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.JobQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.runtime.JobQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.RequestUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.management.JobsPaginateList;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class JobsResource
extends SecuredResource {
    Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();

    public JobsResource() {
        this.properties.put("id", (QueryProperty)JobQueryProperty.JOB_ID);
        this.properties.put("executionId", (QueryProperty)JobQueryProperty.EXECUTION_ID);
        this.properties.put("processInstanceId", (QueryProperty)JobQueryProperty.PROCESS_INSTANCE_ID);
        this.properties.put("dueDate", (QueryProperty)JobQueryProperty.DUEDATE);
        this.properties.put("retries", (QueryProperty)JobQueryProperty.RETRIES);
    }

    @Get
    public DataResponse getJobs() {
        if (!this.authenticate("admin")) {
            return null;
        }
        String processInstanceId = this.getQuery().getValues("process-instance");
        Boolean withRetriesLeft = RequestUtil.getBoolean((Form)this.getQuery(), (String)"with-retries-left", (boolean)false);
        Boolean executable = RequestUtil.getBoolean((Form)this.getQuery(), (String)"executable", (boolean)false);
        Boolean onlyTimers = RequestUtil.getBoolean((Form)this.getQuery(), (String)"only-timers", (boolean)false);
        Boolean onlyMessages = RequestUtil.getBoolean((Form)this.getQuery(), (String)"only-messages", (boolean)false);
        Date dueDateLowerThan = RequestUtil.getDate((Form)this.getQuery(), (String)"duedate-lt");
        Date dueDateLowerThanOrEquals = RequestUtil.getDate((Form)this.getQuery(), (String)"duedate-ltoe");
        Date dueDateHigherThan = RequestUtil.getDate((Form)this.getQuery(), (String)"duedate-ht");
        Date dueDateHigherThanOrEquals = RequestUtil.getDate((Form)this.getQuery(), (String)"duedate-htoe");
        JobQuery jobQuery = ActivitiUtil.getManagementService().createJobQuery();
        if (processInstanceId != null) {
            jobQuery.processInstanceId(processInstanceId);
        }
        if (withRetriesLeft.booleanValue()) {
            jobQuery.withRetriesLeft();
        }
        if (executable.booleanValue()) {
            jobQuery.executable();
        }
        if (onlyTimers.booleanValue()) {
            jobQuery.timers();
        }
        if (onlyMessages.booleanValue()) {
            jobQuery.messages();
        }
        if (dueDateLowerThan != null) {
            jobQuery.duedateLowerThan(dueDateLowerThan);
        }
        if (dueDateLowerThanOrEquals != null) {
            jobQuery.duedateLowerThenOrEquals(dueDateLowerThanOrEquals);
        }
        if (dueDateHigherThan != null) {
            jobQuery.duedateHigherThan(dueDateHigherThan);
        }
        if (dueDateHigherThanOrEquals != null) {
            jobQuery.duedateLowerThenOrEquals(dueDateHigherThanOrEquals);
        }
        DataResponse response = new JobsPaginateList().paginateList(this.getQuery(), (Query)jobQuery, "id", this.properties);
        return response;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

