/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class TablesResource
extends SecuredResource {
    @Get
    public ObjectNode getTables() {
        if (!this.authenticate("admin")) {
            return null;
        }
        Map tableCounts = ActivitiUtil.getManagementService().getTableCount();
        ArrayList tableNames = new ArrayList(tableCounts.keySet());
        Collections.sort(tableNames);
        ObjectNode responseJSON = new ObjectMapper().createObjectNode();
        ArrayNode tablesJSON = new ObjectMapper().createArrayNode();
        responseJSON.put("data", (JsonNode)tablesJSON);
        for (String tableName : tableNames) {
            ObjectNode tableJSON = new ObjectMapper().createObjectNode();
            tableJSON.put("tableName", tableName);
            tableJSON.put("total", (Long)tableCounts.get(tableName));
            tablesJSON.add((JsonNode)tableJSON);
        }
        return responseJSON;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

