/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.process;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.TaskQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.task.TaskQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.legacy.LegacyTasksPaginateList;
import org.restlet.data.Status;
import org.restlet.resource.Get;

public class ProcessInstanceTaskResource
extends SecuredResource {
    Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();

    public ProcessInstanceTaskResource() {
        this.properties.put("id", (QueryProperty)TaskQueryProperty.TASK_ID);
        this.properties.put("name", (QueryProperty)TaskQueryProperty.NAME);
        this.properties.put("description", (QueryProperty)TaskQueryProperty.DESCRIPTION);
        this.properties.put("priority", (QueryProperty)TaskQueryProperty.PRIORITY);
        this.properties.put("assignee", (QueryProperty)TaskQueryProperty.ASSIGNEE);
        this.properties.put("executionId", (QueryProperty)TaskQueryProperty.EXECUTION_ID);
        this.properties.put("processInstanceId", (QueryProperty)TaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Get
    public DataResponse getTasks() {
        if (!this.authenticate()) {
            return null;
        }
        String processInstanceId = (String)this.getRequest().getAttributes().get("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("No process instance id provided");
        }
        TaskQuery taskQuery = ActivitiUtil.getTaskService().createTaskQuery().processInstanceId(processInstanceId);
        DataResponse dataResponse = new LegacyTasksPaginateList().paginateList(this.getQuery(), (Query)taskQuery, "id", this.properties);
        return dataResponse;
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

