/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.legacy.process;

import java.util.HashMap;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.runtime.Execution;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;

public class SignalEventSubscriptionResource
extends SecuredResource {
    @Post
    public ObjectNode signalEventSubscription(Representation entity) {
        ObjectNode responseJSON = new ObjectMapper().createObjectNode();
        String processInstanceId = (String)this.getRequest().getAttributes().get("processInstanceId");
        String signalName = (String)this.getRequest().getAttributes().get("signalName");
        if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
            responseJSON.put("success", false);
            responseJSON.put("failureReason", "No process instance is provided");
            return responseJSON;
        }
        if (StringUtils.isEmpty((CharSequence)signalName)) {
            responseJSON.put("success", false);
            responseJSON.put("failureReason", "No signal name is provided");
            return responseJSON;
        }
        try {
            String signalVariables;
            if (!this.authenticate()) {
                responseJSON.put("success", false);
                responseJSON.put("failureReason", "Not authenticated");
                return responseJSON;
            }
            HashMap variables = new HashMap();
            if (entity != null && StringUtils.isNotEmpty((CharSequence)(signalVariables = entity.getText()))) {
                JsonNode startJSON = new ObjectMapper().readTree(signalVariables);
                variables.putAll(this.retrieveVariables(startJSON));
            }
            List executionList = ActivitiUtil.getRuntimeService().createExecutionQuery().signalEventSubscriptionName(signalName).list();
            for (Execution execution : executionList) {
                if (!execution.getProcessInstanceId().equals(processInstanceId)) continue;
                if (variables.size() > 0) {
                    ActivitiUtil.getRuntimeService().signalEventReceived(signalName, execution.getId(), variables);
                    continue;
                }
                ActivitiUtil.getRuntimeService().signalEventReceived(signalName, execution.getId());
            }
            responseJSON.put("success", true);
            return responseJSON;
        }
        catch (Exception e) {
            if (e instanceof ActivitiException) {
                throw (ActivitiException)e;
            }
            throw new ActivitiException("Failed to signal receive task for process instance id " + processInstanceId, (Throwable)e);
        }
    }

    protected Status getAuthenticationFailureStatus() {
        return Status.CLIENT_ERROR_FORBIDDEN;
    }
}

