/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.management;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.management.TablePage;
import org.activiti.engine.management.TablePageQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.restlet.data.Form;
import org.restlet.resource.Get;

public class TableDataResource
extends SecuredResource {
    protected static final Integer DEFAULT_RESULT_SIZE = 10;

    @Get
    public DataResponse getTableData() {
        Integer size;
        if (!this.authenticate()) {
            return null;
        }
        String tableName = this.getAttribute("tableName");
        if (tableName == null) {
            throw new ActivitiIllegalArgumentException("The tableName cannot be null");
        }
        if (ActivitiUtil.getManagementService().getTableMetaData(tableName) == null) {
            throw new ActivitiObjectNotFoundException("Could not find a table with name '" + tableName + "'.", String.class);
        }
        Form queryForm = this.getQuery();
        String orderAsc = this.getQueryParameter("orderAscendingColumn", queryForm);
        String orderDesc = this.getQueryParameter("orderDescendingColumn", queryForm);
        if (orderAsc != null && orderDesc != null) {
            throw new ActivitiIllegalArgumentException("Only one of 'orderAscendingColumn' or 'orderDescendingColumn' can be supplied.");
        }
        Integer start = this.getQueryParameterAsInt("start", queryForm);
        if (start == null) {
            start = 0;
        }
        if ((size = this.getQueryParameterAsInt("size", queryForm)) == null) {
            size = DEFAULT_RESULT_SIZE;
        }
        DataResponse response = new DataResponse();
        TablePageQuery tablePageQuery = ActivitiUtil.getManagementService().createTablePageQuery().tableName(tableName);
        if (orderAsc != null) {
            tablePageQuery.orderAsc(orderAsc);
            response.setOrder("asc");
            response.setSort(orderAsc);
        }
        if (orderDesc != null) {
            tablePageQuery.orderDesc(orderDesc);
            response.setOrder("desc");
            response.setSort(orderDesc);
        }
        TablePage listPage = tablePageQuery.listPage(start.intValue(), size.intValue());
        response.setSize(Long.valueOf(listPage.getSize()).intValue());
        response.setStart(Long.valueOf(listPage.getFirstResult()).intValue());
        response.setTotal(listPage.getTotal());
        response.setData((Object)listPage.getRows());
        return response;
    }
}

