/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.ProcessDefinitionQueryProperty;
import org.activiti.engine.query.Query;
import org.activiti.engine.query.QueryProperty;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.repository.ProcessDefinitionsPaginateList;
import org.restlet.data.Form;
import org.restlet.resource.Get;

public class ProcessDefinitionCollectionResource
extends SecuredResource {
    private static final Map<String, QueryProperty> properties = new HashMap<String, QueryProperty>();

    @Get
    public DataResponse getProcessDefinitions() {
        Boolean latest;
        Boolean suspended;
        if (!this.authenticate()) {
            return null;
        }
        ProcessDefinitionQuery processDefinitionQuery = ActivitiUtil.getRepositoryService().createProcessDefinitionQuery();
        Form query = this.getQuery();
        Set names = query.getNames();
        if (names.contains("category")) {
            processDefinitionQuery.processDefinitionCategory(this.getQueryParameter("category", query));
        }
        if (names.contains("categoryLike")) {
            processDefinitionQuery.processDefinitionCategoryLike(this.getQueryParameter("categoryLike", query));
        }
        if (names.contains("categoryNotEquals")) {
            processDefinitionQuery.processDefinitionCategoryNotEquals(this.getQueryParameter("categoryNotEquals", query));
        }
        if (names.contains("key")) {
            processDefinitionQuery.processDefinitionKey(this.getQueryParameter("key", query));
        }
        if (names.contains("keyLike")) {
            processDefinitionQuery.processDefinitionKeyLike(this.getQueryParameter("keyLike", query));
        }
        if (names.contains("name")) {
            processDefinitionQuery.processDefinitionName(this.getQueryParameter("name", query));
        }
        if (names.contains("nameLike")) {
            processDefinitionQuery.processDefinitionNameLike(this.getQueryParameter("nameLike", query));
        }
        if (names.contains("resourceName")) {
            processDefinitionQuery.processDefinitionResourceName(this.getQueryParameter("resourceName", query));
        }
        if (names.contains("resourceNameLike")) {
            processDefinitionQuery.processDefinitionResourceNameLike(this.getQueryParameter("resourceNameLike", query));
        }
        if (names.contains("version")) {
            processDefinitionQuery.processDefinitionVersion(this.getQueryParameterAsInt("version", query));
        }
        if (names.contains("suspended") && (suspended = this.getQueryParameterAsBoolean("suspended", query)) != null) {
            if (suspended.booleanValue()) {
                processDefinitionQuery.suspended();
            } else {
                processDefinitionQuery.active();
            }
        }
        if (names.contains("latest") && (latest = this.getQueryParameterAsBoolean("latest", query)) != null && latest.booleanValue()) {
            processDefinitionQuery.latestVersion();
        }
        if (names.contains("deploymentId")) {
            processDefinitionQuery.deploymentId(this.getQueryParameter("deploymentId", query));
        }
        if (names.contains("startableByUser")) {
            processDefinitionQuery.startableByUser(this.getQueryParameter("startableByUser", query));
        }
        return new ProcessDefinitionsPaginateList(this).paginateList(this.getQuery(), (Query)processDefinitionQuery, "name", properties);
    }

    static {
        properties.put("id", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_ID);
        properties.put("key", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_KEY);
        properties.put("category", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_CATEGORY);
        properties.put("name", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_NAME);
        properties.put("version", (QueryProperty)ProcessDefinitionQueryProperty.PROCESS_DEFINITION_VERSION);
        properties.put("deploymentId", (QueryProperty)ProcessDefinitionQueryProperty.DEPLOYMENT_ID);
    }
}

