/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import java.util.Date;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.repository.BaseProcessDefinitionResource;
import org.activiti.rest.service.api.repository.ProcessDefinitionActionRequest;
import org.activiti.rest.service.api.repository.ProcessDefinitionResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ResourceException;

public class ProcessDefinitionResource
extends BaseProcessDefinitionResource {
    @Get
    public ProcessDefinitionResponse getProcessDefinition() {
        if (!this.authenticate()) {
            return null;
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest();
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createProcessDefinitionResponse(this, processDefinition);
    }

    @Put
    public ProcessDefinitionResponse executeProcessDefinitionAction(ProcessDefinitionActionRequest actionRequest) {
        if (!this.authenticate()) {
            return null;
        }
        if (actionRequest == null) {
            throw new ActivitiIllegalArgumentException("No action found in request body.");
        }
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest();
        if (actionRequest.getCategory() != null) {
            ActivitiUtil.getRepositoryService().setProcessDefinitionCategory(processDefinition.getId(), actionRequest.getCategory());
            ProcessDefinitionResponse response = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createProcessDefinitionResponse(this, processDefinition);
            response.setCategory(actionRequest.getCategory());
            return response;
        }
        if (actionRequest.getAction() != null) {
            if ("suspend".equals(actionRequest.getAction())) {
                return this.suspendProcessDefinition(processDefinition, actionRequest.isIncludeProcessInstances(), actionRequest.getDate());
            }
            if ("activate".equals(actionRequest.getAction())) {
                return this.activateProcessDefinition(processDefinition, actionRequest.isIncludeProcessInstances(), actionRequest.getDate());
            }
        }
        throw new ActivitiIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
    }

    protected ProcessDefinitionResponse activateProcessDefinition(ProcessDefinition processDefinition, boolean suspendInstances, Date date) {
        if (!processDefinition.isSuspended()) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT.getCode(), "Process definition with id '" + processDefinition.getId() + " ' is already active", null, null);
        }
        ActivitiUtil.getRepositoryService().activateProcessDefinitionById(processDefinition.getId(), suspendInstances, date);
        ProcessDefinitionResponse response = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createProcessDefinitionResponse(this, processDefinition);
        response.setSuspended(false);
        return response;
    }

    protected ProcessDefinitionResponse suspendProcessDefinition(ProcessDefinition processDefinition, boolean suspendInstances, Date date) {
        if (processDefinition.isSuspended()) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT.getCode(), "Process definition with id '" + processDefinition.getId() + " ' is already suspended", null, null);
        }
        ActivitiUtil.getRepositoryService().suspendProcessDefinitionById(processDefinition.getId(), suspendInstances, date);
        ProcessDefinitionResponse response = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createProcessDefinitionResponse(this, processDefinition);
        response.setSuspended(true);
        return response;
    }
}

