/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.runtime.process.ExecutionActionRequest;
import org.activiti.rest.service.api.runtime.process.ExecutionBaseResource;
import org.activiti.rest.service.api.runtime.process.ExecutionQueryRequest;
import org.restlet.data.Form;
import org.restlet.resource.Get;
import org.restlet.resource.Put;

public class ExecutionCollectionResource
extends ExecutionBaseResource {
    @Get
    public DataResponse getProcessInstances() {
        if (!this.authenticate()) {
            return null;
        }
        Form urlQuery = this.getQuery();
        ExecutionQueryRequest queryRequest = new ExecutionQueryRequest();
        if (this.getQueryParameter("id", urlQuery) != null) {
            queryRequest.setId(this.getQueryParameter("id", urlQuery));
        }
        if (this.getQueryParameter("processInstanceId", urlQuery) != null) {
            queryRequest.setProcessInstanceId(this.getQueryParameter("processInstanceId", urlQuery));
        }
        if (this.getQueryParameter("processInstanceBusinessKey", urlQuery) != null) {
            queryRequest.setProcessBusinessKey(this.getQueryParameter("processInstanceBusinessKey", urlQuery));
        }
        if (this.getQueryParameter("processDefinitionKey", urlQuery) != null) {
            queryRequest.setProcessDefinitionKey(this.getQueryParameter("processDefinitionKey", urlQuery));
        }
        if (this.getQueryParameter("processDefinitionId", urlQuery) != null) {
            queryRequest.setProcessDefinitionId(this.getQueryParameter("processDefinitionId", urlQuery));
        }
        if (this.getQueryParameter("messageEventSubscriptionName", urlQuery) != null) {
            queryRequest.setMessageEventSubscriptionName(this.getQueryParameter("messageEventSubscriptionName", urlQuery));
        }
        if (this.getQueryParameter("signalEventSubscriptionName", urlQuery) != null) {
            queryRequest.setSignalEventSubscriptionName(this.getQueryParameter("signalEventSubscriptionName", urlQuery));
        }
        if (this.getQueryParameter("activityId", urlQuery) != null) {
            queryRequest.setActivityId(this.getQueryParameter("activityId", urlQuery));
        }
        if (this.getQueryParameter("parentId", urlQuery) != null) {
            queryRequest.setParentId(this.getQueryParameter("parentId", urlQuery));
        }
        if (this.getQueryParameter("tenantId", urlQuery) != null) {
            queryRequest.setTenantId(this.getQueryParameter("tenantId", urlQuery));
        }
        if (this.getQueryParameter("tenantIdLike", urlQuery) != null) {
            queryRequest.setTenantIdLike(this.getQueryParameter("tenantIdLike", urlQuery));
        }
        if (Boolean.TRUE.equals(this.getQueryParameterAsBoolean("withoutTenantId", urlQuery))) {
            queryRequest.setWithoutTenantId(Boolean.TRUE);
        }
        return this.getQueryResponse(queryRequest, urlQuery);
    }

    @Put
    public void executeExecutionAction(ExecutionActionRequest actionRequest) {
        if (!this.authenticate()) {
            return;
        }
        if (!"signalEventReceived".equals(actionRequest.getAction())) {
            throw new ActivitiIllegalArgumentException("Illegal action: '" + actionRequest.getAction() + "'.");
        }
        if (actionRequest.getSignalName() == null) {
            throw new ActivitiIllegalArgumentException("Signal name is required.");
        }
        if (actionRequest.getVariables() != null) {
            ActivitiUtil.getRuntimeService().signalEventReceived(actionRequest.getSignalName(), this.getVariablesToSet(actionRequest));
        } else {
            ActivitiUtil.getRuntimeService().signalEventReceived(actionRequest.getSignalName());
        }
    }
}

