/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import java.util.HashMap;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.BaseProcessInstanceResource;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceCreateRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceQueryRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class ProcessInstanceCollectionResource
extends BaseProcessInstanceResource {
    @Get
    public DataResponse getProcessInstances() {
        if (!this.authenticate()) {
            return null;
        }
        Form urlQuery = this.getQuery();
        ProcessInstanceQueryRequest queryRequest = new ProcessInstanceQueryRequest();
        if (this.getQueryParameter("id", urlQuery) != null) {
            queryRequest.setProcessInstanceId(this.getQueryParameter("id", urlQuery));
        }
        if (this.getQueryParameter("processDefinitionKey", urlQuery) != null) {
            queryRequest.setProcessDefinitionKey(this.getQueryParameter("processDefinitionKey", urlQuery));
        }
        if (this.getQueryParameter("processDefinitionId", urlQuery) != null) {
            queryRequest.setProcessDefinitionId(this.getQueryParameter("processDefinitionId", urlQuery));
        }
        if (this.getQueryParameter("businessKey", urlQuery) != null) {
            queryRequest.setProcessBusinessKey(this.getQueryParameter("businessKey", urlQuery));
        }
        if (this.getQueryParameter("involvedUser", urlQuery) != null) {
            queryRequest.setInvolvedUser(this.getQueryParameter("involvedUser", urlQuery));
        }
        if (this.getQueryParameter("suspended", urlQuery) != null) {
            queryRequest.setSuspended(this.getQueryParameterAsBoolean("suspended", urlQuery));
        }
        if (this.getQueryParameter("superProcessInstanceId", urlQuery) != null) {
            queryRequest.setSuperProcessInstanceId(this.getQueryParameter("superProcessInstanceId", urlQuery));
        }
        if (this.getQueryParameter("subProcessInstanceId", urlQuery) != null) {
            queryRequest.setSubProcessInstanceId(this.getQueryParameter("subProcessInstanceId", urlQuery));
        }
        if (this.getQueryParameter("excludeSubprocesses", urlQuery) != null) {
            queryRequest.setExcludeSubprocesses(this.getQueryParameterAsBoolean("excludeSubprocesses", urlQuery));
        }
        if (this.getQueryParameter("includeProcessVariables", urlQuery) != null) {
            queryRequest.setIncludeProcessVariables(this.getQueryParameterAsBoolean("includeProcessVariables", urlQuery));
        }
        if (this.getQueryParameter("tenantId", urlQuery) != null) {
            queryRequest.setTenantId(this.getQueryParameter("tenantId", urlQuery));
        }
        if (this.getQueryParameter("tenantIdLike", urlQuery) != null) {
            queryRequest.setTenantIdLike(this.getQueryParameter("tenantIdLike", urlQuery));
        }
        if (Boolean.TRUE.equals(this.getQueryParameterAsBoolean("withoutTenantId", urlQuery))) {
            queryRequest.setWithoutTenantId(Boolean.TRUE);
        }
        return this.getQueryResponse(queryRequest, urlQuery);
    }

    @Post
    public ProcessInstanceResponse createProcessInstance(ProcessInstanceCreateRequest request) {
        if (!this.authenticate()) {
            return null;
        }
        if (request.getProcessDefinitionId() == null && request.getProcessDefinitionKey() == null && request.getMessage() == null) {
            throw new ActivitiIllegalArgumentException("Either processDefinitionId, processDefinitionKey or message is required.");
        }
        int paramsSet = (request.getProcessDefinitionId() != null ? 1 : 0) + (request.getProcessDefinitionKey() != null ? 1 : 0) + (request.getMessage() != null ? 1 : 0);
        if (paramsSet > 1) {
            throw new ActivitiIllegalArgumentException("Only one of processDefinitionId, processDefinitionKey or message should be set.");
        }
        if (request.isCustomTenantSet() && request.getProcessDefinitionId() != null) {
            throw new ActivitiIllegalArgumentException("TenantId can only be used with either processDefinitionKey or message.");
        }
        RestResponseFactory factory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        HashMap<String, Object> startVariables = null;
        if (request.getVariables() != null) {
            startVariables = new HashMap<String, Object>();
            for (RestVariable variable : request.getVariables()) {
                if (variable.getName() == null) {
                    throw new ActivitiIllegalArgumentException("Variable name is required.");
                }
                startVariables.put(variable.getName(), factory.getVariableValue(variable));
            }
        }
        try {
            ProcessInstance instance = null;
            instance = request.getProcessDefinitionId() != null ? ActivitiUtil.getRuntimeService().startProcessInstanceById(request.getProcessDefinitionId(), request.getBusinessKey(), startVariables) : (request.getProcessDefinitionKey() != null ? (request.isCustomTenantSet() ? ActivitiUtil.getRuntimeService().startProcessInstanceByKeyAndTenantId(request.getProcessDefinitionKey(), request.getBusinessKey(), startVariables, request.getTenantId()) : ActivitiUtil.getRuntimeService().startProcessInstanceByKey(request.getProcessDefinitionKey(), request.getBusinessKey(), startVariables)) : (request.isCustomTenantSet() ? ActivitiUtil.getRuntimeService().startProcessInstanceByMessageAndTenantId(request.getMessage(), request.getBusinessKey(), startVariables, request.getTenantId()) : ActivitiUtil.getRuntimeService().startProcessInstanceByMessage(request.getMessage(), request.getBusinessKey(), startVariables)));
            this.setStatus(Status.SUCCESS_CREATED);
            return factory.createProcessInstanceResponse(this, instance);
        }
        catch (ActivitiObjectNotFoundException aonfe) {
            throw new ActivitiIllegalArgumentException(aonfe.getMessage(), (Throwable)aonfe);
        }
    }
}

