/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.process;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.common.api.SecuredResource;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.process.ExecutionVariableResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;

public class ProcessInstanceVariableResource
extends ExecutionVariableResource {
    @Override
    protected Execution getExecutionFromRequest() {
        String processInstanceId = this.getAttribute("processInstanceId");
        if (processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("The processInstanceId cannot be null");
        }
        Execution execution = (Execution)ActivitiUtil.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process instance with id '" + processInstanceId + "'.", ProcessInstance.class);
        }
        return execution;
    }

    @Override
    protected RestVariable constructRestVariable(SecuredResource securedResource, String variableName, Object value, RestVariable.RestVariableScope variableScope, String executionId, boolean includeBinary) {
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestVariable(this, variableName, value, null, executionId, 3, includeBinary);
    }

    @Override
    protected String getExecutionIdParameter() {
        return "processInstanceId";
    }

    @Override
    protected boolean allowProcessInstanceUrl() {
        return true;
    }
}

