/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.AttachmentRequest;
import org.activiti.rest.service.api.engine.AttachmentResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;

public class TaskAttachmentCollectionResource
extends TaskBaseResource {
    @Get
    public List<AttachmentResponse> getAttachments() {
        if (!this.authenticate()) {
            return null;
        }
        ArrayList<AttachmentResponse> result = new ArrayList<AttachmentResponse>();
        RestResponseFactory responseFactory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
        HistoricTaskInstance task = this.getHistoricTaskFromRequest();
        for (Attachment attachment : ActivitiUtil.getTaskService().getTaskAttachments(task.getId())) {
            result.add(responseFactory.createAttachmentResponse(this, attachment));
        }
        return result;
    }

    @Post
    public AttachmentResponse createAttachment(Representation representation) {
        if (!this.authenticate()) {
            return null;
        }
        AttachmentResponse result = null;
        Task task = this.getTaskFromRequest();
        try {
            result = MediaType.MULTIPART_FORM_DATA.isCompatible((Metadata)representation.getMediaType()) ? this.createBinaryAttachment(representation, task) : this.createSimpleAttachment(representation, task);
        }
        catch (IOException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)e);
        }
        catch (FileUploadException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)e);
        }
        this.setStatus(Status.SUCCESS_CREATED);
        return result;
    }

    protected AttachmentResponse createSimpleAttachment(Representation representation, Task task) throws IOException {
        AttachmentRequest req = (AttachmentRequest)this.getConverterService().toObject(representation, AttachmentRequest.class, (Resource)this);
        if (req.getName() == null) {
            throw new ActivitiIllegalArgumentException("Attachment name is required.");
        }
        Attachment createdAttachment = ActivitiUtil.getTaskService().createAttachment(req.getType(), task.getId(), task.getProcessInstanceId(), req.getName(), req.getDescription(), req.getExternalUrl());
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createAttachmentResponse(this, createdAttachment);
    }

    protected AttachmentResponse createBinaryAttachment(Representation representation, Task task) throws FileUploadException, IOException {
        RestletFileUpload upload = new RestletFileUpload((FileItemFactory)new DiskFileItemFactory());
        List items = upload.parseRepresentation(representation);
        String name = null;
        String description = null;
        String type = null;
        FileItem uploadItem = null;
        for (FileItem fileItem : items) {
            if (fileItem.isFormField()) {
                if ("name".equals(fileItem.getFieldName())) {
                    name = fileItem.getString("UTF-8");
                    continue;
                }
                if ("description".equals(fileItem.getFieldName())) {
                    description = fileItem.getString("UTF-8");
                    continue;
                }
                if (!"type".equals(fileItem.getFieldName())) continue;
                type = fileItem.getString("UTF-8");
                continue;
            }
            if (fileItem.getName() == null) continue;
            uploadItem = fileItem;
        }
        if (name == null) {
            throw new ActivitiIllegalArgumentException("Attachment name is required.");
        }
        if (uploadItem == null) {
            throw new ActivitiIllegalArgumentException("Attachment content is required.");
        }
        Attachment createdAttachment = ActivitiUtil.getTaskService().createAttachment(type, task.getId(), task.getProcessInstanceId(), name, description, uploadItem.getInputStream());
        this.setStatus(Status.SUCCESS_CREATED);
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createAttachmentResponse(this, createdAttachment);
    }
}

