/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.engine.CommentResponse;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.Status;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;

public class TaskCommentResource
extends TaskBaseResource {
    @Get
    public CommentResponse getComment() {
        if (!this.authenticate()) {
            return null;
        }
        HistoricTaskInstance task = this.getHistoricTaskFromRequest();
        String commentId = this.getAttribute("commentId");
        if (commentId == null) {
            throw new ActivitiIllegalArgumentException("CommentId is required.");
        }
        Comment comment = ActivitiUtil.getTaskService().getComment(commentId);
        if (comment == null || !task.getId().equals(comment.getTaskId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        return ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestComment(this, comment);
    }

    @Delete
    public void deleteComment() {
        if (!this.authenticate()) {
            return;
        }
        Task task = this.getTaskFromRequest();
        String commentId = this.getAttribute("commentId");
        if (commentId == null) {
            throw new ActivitiIllegalArgumentException("CommentId is required.");
        }
        Comment comment = ActivitiUtil.getTaskService().getComment(commentId);
        if (comment == null || comment.getTaskId() == null || !comment.getTaskId().equals(task.getId())) {
            throw new ActivitiObjectNotFoundException("Task '" + task.getId() + "' doesn't have a comment with id '" + commentId + "'.", Comment.class);
        }
        ActivitiUtil.getTaskService().deleteComment(commentId);
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }
}

