/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.task.TaskVariableBaseResource;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;

public class TaskVariableCollectionResource
extends TaskVariableBaseResource {
    @Get
    public List<RestVariable> getVariables() {
        if (!this.authenticate()) {
            return null;
        }
        ArrayList<RestVariable> result = new ArrayList<RestVariable>();
        HashMap<String, RestVariable> variableMap = new HashMap<String, RestVariable>();
        Task task = this.getTaskFromRequest();
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(this.getQueryParameter("scope", this.getQuery()));
        if (variableScope == null) {
            this.addLocalVariables(task, variableMap);
            this.addGlobalVariables(task, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            this.addGlobalVariables(task, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            this.addLocalVariables(task, variableMap);
        }
        result.addAll(variableMap.values());
        return result;
    }

    @Post
    public Object createTaskVariable(Representation representation) {
        Object result;
        block14: {
            if (!this.authenticate()) {
                return null;
            }
            Task task = this.getTaskFromRequest();
            result = null;
            if (MediaType.MULTIPART_FORM_DATA.isCompatible((Metadata)representation.getMediaType())) {
                result = this.setBinaryVariable(representation, task, true);
            } else {
                try {
                    ArrayList<RestVariable> variables = new ArrayList<RestVariable>();
                    result = variables;
                    RestVariable[] restVariables = (RestVariable[])this.getConverterService().toObject(representation, RestVariable[].class, (Resource)this);
                    if (restVariables == null || restVariables.length == 0) {
                        throw new ActivitiIllegalArgumentException("Request didn't contain a list of variables to create.");
                    }
                    RestVariable.RestVariableScope sharedScope = null;
                    RestVariable.RestVariableScope varScope = null;
                    HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
                    RestResponseFactory factory = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory();
                    for (RestVariable var : restVariables) {
                        varScope = var.getVariableScope();
                        if (var.getName() == null) {
                            throw new ActivitiIllegalArgumentException("Variable name is required");
                        }
                        if (varScope == null) {
                            varScope = RestVariable.RestVariableScope.LOCAL;
                        }
                        if (sharedScope == null) {
                            sharedScope = varScope;
                        }
                        if (varScope != sharedScope) {
                            throw new ActivitiIllegalArgumentException("Only allowed to update multiple variables in the same scope.");
                        }
                        if (this.hasVariableOnScope(task, var.getName(), varScope)) {
                            throw new ResourceException(new Status(Status.CLIENT_ERROR_CONFLICT.getCode(), "Variable '" + var.getName() + "' is already present on task '" + task.getId() + "'.", null, null));
                        }
                        Object actualVariableValue = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().getVariableValue(var);
                        variablesToSet.put(var.getName(), actualVariableValue);
                        variables.add(factory.createRestVariable(this, var.getName(), actualVariableValue, varScope, task.getId(), 1, false));
                    }
                    if (variablesToSet.size() <= 0) break block14;
                    if (sharedScope == RestVariable.RestVariableScope.LOCAL) {
                        ActivitiUtil.getTaskService().setVariablesLocal(task.getId(), variablesToSet);
                        break block14;
                    }
                    if (task.getExecutionId() != null) {
                        ActivitiUtil.getRuntimeService().setVariables(task.getExecutionId(), variablesToSet);
                        break block14;
                    }
                    throw new ActivitiIllegalArgumentException("Cannot set global variables on task '" + task.getId() + "', task is not part of process.");
                }
                catch (IOException ioe) {
                    throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)ioe);
                }
            }
        }
        this.setStatus(Status.SUCCESS_CREATED);
        return result;
    }

    @Delete
    public void deleteAllLocalTaskVariables() {
        if (!this.authenticate()) {
            return;
        }
        Task task = this.getTaskFromRequest();
        Set currentVariables = ActivitiUtil.getTaskService().getVariablesLocal(task.getId()).keySet();
        ActivitiUtil.getTaskService().removeVariablesLocal(task.getId(), currentVariables);
        this.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    protected void addGlobalVariables(Task task, Map<String, RestVariable> variableMap) {
        if (task.getExecutionId() != null) {
            Map rawVariables = ActivitiUtil.getRuntimeService().getVariables(task.getExecutionId());
            List<RestVariable> globalVariables = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestVariables(this, rawVariables, task.getId(), 1, RestVariable.RestVariableScope.GLOBAL);
            for (RestVariable var : globalVariables) {
                if (variableMap.containsKey(var.getName())) continue;
                variableMap.put(var.getName(), var);
            }
        }
    }

    protected void addLocalVariables(Task task, Map<String, RestVariable> variableMap) {
        Map rawVariables = ActivitiUtil.getTaskService().getVariablesLocal(task.getId());
        List<RestVariable> localVariables = ((ActivitiRestServicesApplication)this.getApplication(ActivitiRestServicesApplication.class)).getRestResponseFactory().createRestVariables(this, rawVariables, task.getId(), 1, RestVariable.RestVariableScope.LOCAL);
        for (RestVariable var : localVariables) {
            variableMap.put(var.getName(), var);
        }
    }
}

