/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.runtime.task;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.rest.exception.ActivitiForbiddenException;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.runtime.task.TaskActionRequest;
import org.activiti.rest.service.api.runtime.task.TaskBaseResource;
import org.activiti.rest.service.api.runtime.task.TaskRequest;
import org.activiti.rest.service.api.runtime.task.TaskResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TaskResource
extends TaskBaseResource {
    @RequestMapping(value={"/runtime/tasks/{taskId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public TaskResponse getTask(@PathVariable String taskId, HttpServletRequest request) {
        return this.restResponseFactory.createTaskResponse(this.getTaskFromRequest(taskId));
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public TaskResponse updateTask(@PathVariable String taskId, @RequestBody TaskRequest taskRequest, HttpServletRequest request) {
        if (taskRequest == null) {
            throw new ActivitiException("A request body was expected when updating the task.");
        }
        Task task = this.getTaskFromRequest(taskId);
        this.populateTaskFromRequest(task, taskRequest);
        this.taskService.saveTask(task);
        task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(task.getId())).singleResult();
        return this.restResponseFactory.createTaskResponse(task);
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}"}, method={RequestMethod.POST})
    public void executeTaskAction(@PathVariable String taskId, @RequestBody TaskActionRequest actionRequest) {
        if (actionRequest == null) {
            throw new ActivitiException("A request body was expected when executing a task action.");
        }
        Task task = this.getTaskFromRequest(taskId);
        if ("complete".equals(actionRequest.getAction())) {
            this.completeTask(task, actionRequest);
        } else if ("claim".equals(actionRequest.getAction())) {
            this.claimTask(task, actionRequest);
        } else if ("delegate".equals(actionRequest.getAction())) {
            this.delegateTask(task, actionRequest);
        } else if ("resolve".equals(actionRequest.getAction())) {
            this.resolveTask(task, actionRequest);
        } else {
            throw new ActivitiIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
        }
    }

    @RequestMapping(value={"/runtime/tasks/{taskId}"}, method={RequestMethod.DELETE})
    public void deleteTask(@PathVariable String taskId, @RequestParam(value="cascadeHistory", required=false) Boolean cascadeHistory, @RequestParam(value="deleteReason", required=false) String deleteReason, HttpServletResponse response) {
        Task taskToDelete = this.getTaskFromRequest(taskId);
        if (taskToDelete.getExecutionId() != null) {
            throw new ActivitiForbiddenException("Cannot delete a task that is part of a process-instance.");
        }
        if (cascadeHistory != null) {
            this.taskService.deleteTask(taskToDelete.getId(), cascadeHistory.booleanValue());
        } else {
            this.taskService.deleteTask(taskToDelete.getId(), deleteReason);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    protected void completeTask(Task task, TaskActionRequest actionRequest) {
        if (actionRequest.getVariables() != null) {
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            for (RestVariable var : actionRequest.getVariables()) {
                if (var.getName() == null) {
                    throw new ActivitiIllegalArgumentException("Variable name is required");
                }
                Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
                variablesToSet.put(var.getName(), actualVariableValue);
            }
            this.taskService.complete(task.getId(), variablesToSet);
        } else {
            this.taskService.complete(task.getId());
        }
    }

    protected void resolveTask(Task task, TaskActionRequest actionRequest) {
        this.taskService.resolveTask(task.getId());
    }

    protected void delegateTask(Task task, TaskActionRequest actionRequest) {
        if (actionRequest.getAssignee() == null) {
            throw new ActivitiIllegalArgumentException("An assignee is required when delegating a task.");
        }
        this.taskService.delegateTask(task.getId(), actionRequest.getAssignee());
    }

    protected void claimTask(Task task, TaskActionRequest actionRequest) {
        this.taskService.claim(task.getId(), actionRequest.getAssignee());
    }
}

