/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.exception;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.rest.exception.ActivitiConflictException;
import org.activiti.rest.exception.ActivitiContentNotSupportedException;
import org.activiti.rest.exception.ActivitiForbiddenException;
import org.activiti.rest.exception.ErrorInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class ExceptionHandlerAdvice {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);

    @ResponseStatus(value=HttpStatus.UNSUPPORTED_MEDIA_TYPE)
    @ExceptionHandler(value={ActivitiContentNotSupportedException.class})
    @ResponseBody
    public ErrorInfo handleNotSupported(ActivitiContentNotSupportedException e) {
        return new ErrorInfo("Content is not supported", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={ActivitiConflictException.class})
    @ResponseBody
    public ErrorInfo handleConflict(ActivitiConflictException e) {
        return new ErrorInfo("Conflict", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseBody
    public ErrorInfo handleTaskAlreadyClaimed(ActivitiTaskAlreadyClaimedException e) {
        return new ErrorInfo("Task was already claimed", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseBody
    public ErrorInfo handleNotFound(ActivitiObjectNotFoundException e) {
        return new ErrorInfo("Not found", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={ActivitiForbiddenException.class})
    @ResponseBody
    public ErrorInfo handleForbidden(ActivitiForbiddenException e) {
        return new ErrorInfo("Forbidden", (Exception)((Object)e));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseBody
    public ErrorInfo handleIllegal(ActivitiIllegalArgumentException e) {
        return new ErrorInfo("Bad request", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageConversionException.class})
    @ResponseBody
    public ErrorInfo handleBadMessageConversion(HttpMessageConversionException e) {
        return new ErrorInfo("Bad request", (Exception)e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ErrorInfo handleOtherException(Exception e) {
        LOGGER.error("Unhandled exception", (Throwable)e);
        return new ErrorInfo("Internal server error", e);
    }
}

