/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.process.model.builders;

import java.util.HashSet;
import java.util.Set;
import org.activiti.api.process.model.payloads.GetProcessInstancesPayload;

public class GetProcessInstancesPayloadBuilder {
    private String businessKey;
    private Set<String> processDefinitionKeys = new HashSet<String>();
    private boolean suspendedOnly = false;
    private boolean activeOnly = false;

    public GetProcessInstancesPayloadBuilder withBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public GetProcessInstancesPayloadBuilder withProcessDefinitionKeys(Set<String> processDefinitionKeys) {
        this.processDefinitionKeys = processDefinitionKeys;
        return this;
    }

    public GetProcessInstancesPayloadBuilder withProcessDefinitionKey(String processDefinitionKey) {
        if (this.processDefinitionKeys == null) {
            this.processDefinitionKeys = new HashSet<String>();
        }
        this.processDefinitionKeys.add(processDefinitionKey);
        return this;
    }

    public GetProcessInstancesPayloadBuilder suspended() {
        this.suspendedOnly = true;
        return this;
    }

    public GetProcessInstancesPayloadBuilder active() {
        this.activeOnly = true;
        return this;
    }

    public GetProcessInstancesPayload build() {
        GetProcessInstancesPayload getProcessInstancesPayload = new GetProcessInstancesPayload();
        getProcessInstancesPayload.setBusinessKey(this.businessKey);
        getProcessInstancesPayload.setProcessDefinitionKeys(this.processDefinitionKeys);
        getProcessInstancesPayload.setActiveOnly(this.activeOnly);
        getProcessInstancesPayload.setSuspendedOnly(this.suspendedOnly);
        return getProcessInstancesPayload;
    }
}

