/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.geometry;

import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.Point;

public class Line
extends Geometry {
    private Double a;
    private Double b;
    private Double c;
    private Point p1;
    private Point p2;

    public Line() {
    }

    public Line(Point p1, Point p2) {
        this.p1 = p1;
        this.p2 = p2;
        this.slope();
    }

    public Line(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.point();
    }

    public double a() {
        return this.a;
    }

    public void a(double a) {
        this.a = a;
        this.point();
    }

    public double b() {
        return this.b;
    }

    public void b(double b) {
        this.b = b;
        this.point();
    }

    public double c() {
        return this.c;
    }

    public void c(double c) {
        this.c = c;
        this.point();
    }

    public Point p1() {
        return this.p1;
    }

    public void p1(Point p1) {
        this.p1 = p1;
        this.slope();
    }

    public Point p2() {
        return this.p2;
    }

    public void p2(Point p2) {
        this.p2 = p2;
        this.slope();
    }

    public Point getP1() {
        return this.p1;
    }

    public void setP1(Point p1) {
        this.p1 = p1;
        this.slope();
    }

    public Point getP2() {
        return this.p2;
    }

    public void setP2(Point p2) {
        this.p2 = p2;
        this.slope();
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean tag) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        builder.append("(");
        builder.append(this.p1.toString(false));
        builder.append(",");
        builder.append(this.p2.toString(false));
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String sql(boolean tag, boolean bracket) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        if (bracket) {
            builder.append("(");
        }
        builder.append(this.p1.sql(false, false));
        builder.append(",");
        builder.append(this.p2.sql(false, false));
        if (bracket) {
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public String sql() {
        return this.sql(true, true);
    }

    public void slope() {
        if (null != this.p1 || null == this.p2) {
            return;
        }
        double x1 = this.p1.x();
        double x2 = this.p2.x();
        double y1 = this.p1.y();
        double y2 = this.p2.y();
        if (x1 == x2) {
            this.a = -1.0;
            this.b = 0.0;
        } else {
            this.a = (y2 - y1) / (x2 - x1);
            this.b = -1.0;
        }
        this.c = y1 - this.a * x1;
    }

    public void point() {
        if (null == this.a || null == this.b || null == this.c) {
            return;
        }
        if (this.b != 0.0) {
            double x1 = 0.0;
            double y1 = (-this.a.doubleValue() * x1 - this.c) / this.b;
            this.p1 = new Point(x1, y1);
            double x2 = 1.0;
            double y2 = (-this.a.doubleValue() * x2 - this.c) / this.b;
            this.p2 = new Point(x2, y2);
        } else {
            double y1 = 0.0;
            double x1 = -this.c.doubleValue() / this.a;
            this.p1 = new Point(x1, y1);
            double y2 = 1.0;
            double x2 = -this.c.doubleValue() / this.a;
            this.p2 = new Point(x2, y2);
        }
    }
}

