/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.Table;
import org.anyline.entity.html.Td;
import org.anyline.entity.html.Tr;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.StyleParser;
import org.anyline.util.regular.RegularUtil;

public class TableBuilder {
    private Collection datas = null;
    private List<String> headers = new ArrayList<String>();
    private String header = null;
    private String footer = null;
    private String clazz = null;
    private List<String> fields = new ArrayList<String>();
    private List<String> unions = new ArrayList<String>();
    private Map<String, Map<String, String>> styles = new HashMap<String, Map<String, String>>();
    private Map<String, String[]> unionRefs = new HashMap<String, String[]>();
    private Map<String, Map<String, String>> options = new HashMap<String, Map<String, String>>();
    private List<String> ignoreUnionValues = new ArrayList<String>();
    private String width = "100%";
    private String widthUnit = "px";
    private String replaceEmpty = "";
    private String cellBorder = "";
    private String lineHeight = "";
    private String mergeCellVerticalAlign = "";
    private String mergeCellHorizontalAlign = "";
    private String emptyCellVerticalAlign = "";
    private String emptyCellHorizontalAlign = "";
    Map<String, String>[][] cells = null;
    Object[] list = null;

    public static TableBuilder init() {
        TableBuilder builder = new TableBuilder();
        return builder;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
    }

    private boolean checkRefMerge(String field, int r, Object prevRow) {
        boolean merge = true;
        String[] refs = this.unionRefs.get(field);
        Object data = this.list[r];
        if (null != refs) {
            for (String ref : refs) {
                String curRefValue;
                if (field.equals(ref)) continue;
                int refIndex = this.fields.indexOf(ref);
                Map<String, String> refCell = this.cells[r][refIndex];
                if (null == refCell.get("checked")) {
                    this.checkMerge(r, refIndex, ref);
                }
                if (null == (curRefValue = BeanUtil.parseRuntimeValue(data, ref))) {
                    curRefValue = this.replaceEmpty;
                }
                if (this.ignoreUnionValues.indexOf(curRefValue) != -1) {
                    merge = false;
                    break;
                }
                String prevRefValue = BeanUtil.parseRuntimeValue(prevRow, ref);
                if (null == prevRefValue) {
                    prevRefValue = this.replaceEmpty;
                }
                if (!curRefValue.equals(prevRefValue)) {
                    merge = false;
                    break;
                }
                if (null == refCell || "1".equals(refCell.get("merge")) || "1".equals(refCell.get("merged"))) continue;
                merge = false;
                break;
            }
        }
        return merge;
    }

    private void checkMerge(int r, int c, String field) {
        Map<String, String> map = this.cells[r][c];
        String value = map.get("value");
        map.put("checked", "1");
        int rowspan = 1;
        if (null != this.unions && this.unions.contains(field)) {
            Object data = this.list[r];
            int rsize = this.list.length;
            for (int rr = r + 1; rr < rsize; ++rr) {
                boolean refMerge;
                Map<String, String> next = this.cells[rr][c];
                Object prevRow = this.list[rr];
                String pvalue = next.get("value");
                if (!pvalue.equals(value) || this.ignoreUnionValues.indexOf(value) != -1 || !(refMerge = this.checkRefMerge(field, r, prevRow))) break;
                map.put("merge", "1");
                next.put("merged", "1");
                ++rowspan;
            }
        }
        map.put("rowspan", rowspan + "");
    }

    private void checkNum(int c, String field) {
        int rows = this.cells.length;
        int num = 1;
        for (int r = 0; r < rows; ++r) {
            int rowspan;
            Map<String, String> refCell;
            Map<String, String> cell = this.cells[r][c];
            cell.put("value", num + "");
            String ref = field.substring(field.indexOf("(") + 1, field.length() - 1);
            int refCol = this.fields.indexOf(ref);
            if (refCol != -1 && null != (refCell = this.cells[r][refCol]) && (rowspan = BasicUtil.parseInt(refCell.get("rowspan"), 1).intValue()) > 1) {
                cell.put("merge", "1");
                cell.put("rowspan", rowspan + "");
                for (int rr = r + 1; rr < r + rowspan && rr < rows; ++rr) {
                    Map<String, String> mergedCell = this.cells[rr][c];
                    mergedCell.put("merged", "1");
                }
                r += rowspan - 1;
            }
            ++num;
        }
    }

    public Table build() {
        int colspan;
        String style;
        String text;
        Td td;
        Tr tr;
        List<String> stds;
        Table table = null;
        table = new Table();
        if (BasicUtil.isNotEmpty(this.width)) {
            table.setWidth(this.width);
        }
        this.parseUnion();
        table.setClazz(this.clazz);
        table.setHeader(this.header);
        if (null != this.header) {
            List<String> strs = RegularUtil.cuts(this.header, "<tr", ">", "</tr>");
            for (String str : strs) {
                stds = RegularUtil.cuts(str, "<td", "</td>");
                tr = new Tr();
                for (String std : stds) {
                    td = new Td();
                    text = RegularUtil.cut(std, ">", "${end}");
                    style = RegularUtil.fetchAttributeValue(std, "style");
                    colspan = BasicUtil.parseInt(RegularUtil.fetchAttributeValue(std, "colspan"), 1);
                    int rowspan = BasicUtil.parseInt(RegularUtil.fetchAttributeValue(std, "rowspan"), 1);
                    td.setColspan(colspan);
                    td.setRowspan(rowspan);
                    td.setText(text);
                    tr.addTd(td);
                }
                table.addTr(tr);
            }
        }
        if (null != this.headers && this.headers.size() > 0) {
            Tr tr2 = new Tr();
            int size = this.headers.size();
            for (int i = 0; i < size; ++i) {
                String header = this.headers.get(i);
                Td td2 = new Td();
                td2.setText(header);
                if (BasicUtil.isNotEmpty(this.cellBorder)) {
                    td2.setBorder();
                }
                tr2.addTd(td2);
            }
            table.addTr(tr2);
        }
        if (null != this.datas && null != this.fields) {
            String value;
            int r;
            this.list = this.datas.toArray();
            int rsize = this.list.length;
            int csize = this.fields.size();
            this.cells = new HashMap[rsize][csize];
            for (r = 0; r < rsize; ++r) {
                Object data = this.list[r];
                for (int c = 0; c < csize; ++c) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String field = this.fields.get(c);
                    value = null;
                    value = field.equals("${num}") ? r + 1 + "" : (field.contains("${num}") ? field : BeanUtil.parseRuntimeValue(data, field));
                    Map<String, String> option = this.options.get(field);
                    if (null != option && null != value) {
                        value = option.get(value);
                    }
                    if (null == value) {
                        value = this.replaceEmpty;
                    }
                    map.put("value", value);
                    this.cells[r][c] = map;
                }
            }
            for (r = 0; r < rsize; ++r) {
                for (int c = 0; c < csize; ++c) {
                    String field = this.fields.get(c);
                    this.checkMerge(r, c, field);
                }
            }
            for (int c = 0; c < csize; ++c) {
                String field = this.fields.get(c);
                if (!field.contains("${num}")) continue;
                this.checkNum(c, field);
            }
            for (r = 0; r < rsize; ++r) {
                Object data = this.list[r];
                Tr tr3 = new Tr();
                for (int c = 0; c < csize; ++c) {
                    Map<String, String> map = this.cells[r][c];
                    value = map.get("value");
                    String merge = map.get("merge");
                    String merged = map.get("merged");
                    int rowspan = BasicUtil.parseInt(map.get("rowspan"), 1);
                    if ("1".equals(merged)) continue;
                    Td td3 = new Td();
                    td3.setText(value);
                    tr3.addTd(td3);
                    Map<String, String> tdStyle = this.styles.get(this.fields.get(c));
                    if (null != tdStyle) {
                        td3.setStyles(tdStyle);
                    }
                    if (rowspan > 1) {
                        td3.setRowspan(rowspan);
                        if (BasicUtil.isNotEmpty(this.mergeCellHorizontalAlign)) {
                            td3.setAlign(this.mergeCellHorizontalAlign);
                        }
                        if (BasicUtil.isNotEmpty(this.mergeCellVerticalAlign)) {
                            td3.setVerticalAlign(this.mergeCellVerticalAlign);
                        }
                    }
                    if (BasicUtil.isEmpty((Object)value) || this.replaceEmpty.equals(value)) {
                        if (BasicUtil.isNotEmpty(this.emptyCellHorizontalAlign)) {
                            td3.setAlign(this.emptyCellHorizontalAlign);
                        }
                        if (BasicUtil.isNotEmpty(this.emptyCellVerticalAlign)) {
                            td3.setVerticalAlign(this.emptyCellVerticalAlign);
                        }
                    }
                    if (!BasicUtil.isNotEmpty(this.cellBorder)) continue;
                    td3.setBorder();
                }
                table.addTr(tr3);
            }
        }
        table.setFooter(this.footer);
        if (null != this.footer) {
            List<String> strs = RegularUtil.cuts(this.footer, "<tr", ">", "</tr>");
            for (String str : strs) {
                stds = RegularUtil.cuts(str, "<td", "</td>");
                tr = new Tr();
                for (String std : stds) {
                    td = new Td();
                    text = RegularUtil.cut(std, ">", "${end}");
                    style = RegularUtil.fetchAttributeValue(std, "style");
                    td.setStyles(StyleParser.parse(style));
                    colspan = BasicUtil.parseInt(RegularUtil.fetchAttributeValue(std, "colspan"), 1);
                    int rowspan = BasicUtil.parseInt(RegularUtil.fetchAttributeValue(std, "rowspan"), 1);
                    td.setColspan(colspan);
                    td.setRowspan(rowspan);
                    td.setText(text);
                    if (BasicUtil.isNotEmpty(this.cellBorder)) {
                        td.setBorder();
                    }
                    tr.addTd(td);
                }
                table.addTr(tr);
            }
        }
        table.offset();
        return table;
    }

    private void parseUnion() {
        ArrayList<String> list = new ArrayList<String>();
        for (String union : this.unions) {
            if (union.contains("(")) {
                union = union.trim();
                String[] refs = union.substring(union.indexOf("(") + 1, union.length() - 1).split(",");
                union = union.substring(0, union.indexOf("("));
                this.unionRefs.put(union, refs);
            }
            list.add(union);
        }
        this.setUnions(list);
    }

    public Collection getDatas() {
        return this.datas;
    }

    public TableBuilder setDatas(Collection datas) {
        this.datas = datas;
        return this;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public TableBuilder setHeaders(List<String> headers) {
        this.headers = headers;
        return this;
    }

    public TableBuilder setHeaders(String ... headers) {
        this.headers = BeanUtil.array2list(new String[][]{headers});
        return this;
    }

    public TableBuilder addHeaders(String ... headers) {
        for (String header : headers) {
            this.headers.add(header);
        }
        return this;
    }

    public TableBuilder addHeaders(List<String> headers) {
        for (String header : headers) {
            this.headers.add(header);
        }
        return this;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public TableBuilder setFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public TableBuilder setFields(String ... fields) {
        this.fields = BeanUtil.array2list(new String[][]{fields});
        return this;
    }

    public TableBuilder setConfigs(String ... configs) {
        this.headers = new ArrayList<String>();
        this.fields = new ArrayList<String>();
        this.addConfigs(configs);
        return this;
    }

    public TableBuilder addConfigs(String ... configs) {
        String[] stringArray = configs;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String config;
            String head = config = stringArray[i];
            String field = config;
            if (config.contains(":")) {
                String[] tmps = config.split(":");
                head = tmps[0];
                field = tmps[1];
            }
            this.addHeaders(head);
            this.addFields(field);
        }
        return this;
    }

    public TableBuilder addFields(String ... fields) {
        for (String field : fields) {
            this.fields.add(field);
        }
        return this;
    }

    public TableBuilder addFields(List<String> fields) {
        for (String field : fields) {
            this.fields.add(field);
        }
        return this;
    }

    public List<String> getUnions() {
        return this.unions;
    }

    public TableBuilder setUnions(List<String> unions) {
        this.unions = unions;
        return this;
    }

    public TableBuilder addUnions(String ... fields) {
        if (null == this.unions) {
            this.unions = new ArrayList<String>();
        }
        for (String field : fields) {
            if (this.unions.contains(field)) continue;
            this.unions.add(field);
        }
        return this;
    }

    public String getClazz() {
        return this.clazz;
    }

    public TableBuilder setClazz(String clazz) {
        this.clazz = clazz;
        return this;
    }

    public String getHeader() {
        return this.header;
    }

    public TableBuilder setHeader(String header) {
        this.header = header;
        return this;
    }

    public String getFooter() {
        return this.footer;
    }

    public TableBuilder setFooter(String footer) {
        this.footer = footer;
        return this;
    }

    public Map<String, Map<String, String>> getStyles() {
        return this.styles;
    }

    public Map<String, String> getStyle(String field) {
        return this.styles.get(field);
    }

    public TableBuilder setStyle(String field, Map<String, String> style) {
        this.styles.put(field, style);
        return this;
    }

    public TableBuilder setHorizontalAlign(String field, String align) {
        Map<String, String> style = this.styles.get(field);
        if (null == style) {
            style = new HashMap<String, String>();
        }
        style.put("text-align", align);
        return this;
    }

    public TableBuilder setHorizontalAlign(String align) {
        if (null != this.fields) {
            for (String field : this.fields) {
                this.setHorizontalAlign(field, align);
            }
        }
        return this;
    }

    public TableBuilder setTextAlign(String field, String align) {
        return this.setHorizontalAlign(field, align);
    }

    public TableBuilder setTextAlign(String align) {
        return this.setHorizontalAlign(align);
    }

    public TableBuilder setVerticalAlign(String field, String align) {
        Map<String, String> style = this.styles.get(field);
        if (null == style) {
            style = new HashMap<String, String>();
        }
        style.put("vertical-align", align);
        return this;
    }

    public TableBuilder setVerticalAlign(String align) {
        if (null != this.fields) {
            for (String field : this.fields) {
                this.setVerticalAlign(field, align);
            }
        }
        return this;
    }

    public TableBuilder addConfig(String header, String field, String width) {
        this.headers.add(header);
        this.fields.add(field);
        Map<String, String> style = this.styles.get(field);
        if (null == style) {
            style = new HashMap<String, String>();
            this.styles.put(field, style);
        }
        style.put("width", width);
        return this;
    }

    public TableBuilder addConfig(String header, String field, int width) {
        return this.addConfig(header, field, width + this.widthUnit);
    }

    public TableBuilder addConfig(String header, String field) {
        this.headers.add(header);
        this.fields.add(field);
        return this;
    }

    public TableBuilder setWidth(String field, String width) {
        Map<String, String> style = this.styles.get(field);
        if (null == style) {
            style = new HashMap<String, String>();
            this.styles.put(field, style);
        }
        style.put("width", width);
        return this;
    }

    public TableBuilder setWidth(String width) {
        this.width = width;
        return this;
    }

    public List<String> getIgnoreUnionValues() {
        return this.ignoreUnionValues;
    }

    public TableBuilder setIgnoreUnionValues(List<String> values) {
        this.ignoreUnionValues = values;
        return this;
    }

    public TableBuilder addIgnoreUnionValue(String ... values) {
        if (null != values) {
            for (String value : values) {
                this.ignoreUnionValues.add(value);
            }
        }
        return this;
    }

    public String getCellBorder() {
        return this.cellBorder;
    }

    public TableBuilder setCellBorder(String border) {
        this.cellBorder = border;
        return this;
    }

    public TableBuilder setCellBorder(boolean border) {
        this.cellBorder = border ? "1px solid auto" : "";
        return this;
    }

    public String getLineHeight() {
        return this.lineHeight;
    }

    public TableBuilder setLineHeight(String height) {
        this.lineHeight = height;
        return this;
    }

    public TableBuilder setReplaceEmpty(String value) {
        this.replaceEmpty = value;
        return this;
    }

    public TableBuilder setMergeCellVerticalAlign(String align) {
        this.mergeCellVerticalAlign = align;
        return this;
    }

    public TableBuilder setMergeCellHorizontalAlign(String align) {
        this.mergeCellHorizontalAlign = align;
        return this;
    }

    public TableBuilder setEmptyCellVerticalAlign(String align) {
        this.emptyCellVerticalAlign = align;
        return this;
    }

    public TableBuilder setEmptyCellHorizontalAlign(String align) {
        this.emptyCellHorizontalAlign = align;
        return this;
    }

    public TableBuilder setOptions(String field, Map<String, String> option) {
        this.options.put(field, option);
        return this;
    }

    public TableBuilder addOptions(String field, Map<String, String> option) {
        Map<String, String> map = this.options.get(field);
        if (null == map) {
            map = option;
        } else {
            map.putAll(option);
        }
        this.options.put(field, map);
        return this;
    }

    public TableBuilder addOptions(String field, String ... kvs) {
        Map<String, String> map = this.options.get(field);
        if (null != kvs) {
            Map<String, String> tmps = BeanUtil.array2map(kvs);
            if (map == null) {
                map = tmps;
            } else {
                map.putAll(tmps);
            }
        }
        this.options.put(field, map);
        return this;
    }

    public TableBuilder setOptions(String field, String ... kvs) {
        if (null != kvs) {
            Map<String, String> map = BeanUtil.array2map(kvs);
            this.options.put(field, map);
        }
        return this;
    }

    public TableBuilder setOptions(String field, Collection datas, String value, String text) {
        this.options.remove(field);
        this.addOptions(field, datas, value, text);
        return this;
    }

    public TableBuilder addOptions(String field, Collection datas, String value, String text) {
        Map<String, String> map = this.options.get(field);
        if (null == map) {
            map = new HashMap<String, String>();
        }
        for (Object obj : datas) {
            String v = null;
            String t = null;
            Object ov = BeanUtil.getFieldValue(obj, value);
            Object ot = BeanUtil.getFieldValue(obj, text);
            if (null != ov) {
                v = ov.toString();
            }
            if (null != ot) {
                t = ot.toString();
            }
            map.put(v, t);
        }
        this.options.put(field, map);
        return this;
    }
}

