/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.util.BeanUtil;

public class Index<M extends Index>
extends BaseMetadata<M>
implements Serializable {
    protected String keyword = "INDEX";
    protected String type;
    protected LinkedHashMap<String, Column> columns = new LinkedHashMap();
    protected boolean primary;
    protected boolean cluster;
    protected boolean fulltext;
    protected boolean spatial;
    protected LinkedHashMap<String, Integer> positions = new LinkedHashMap();
    protected boolean unique;

    public Index() {
    }

    public Index(String name) {
        this.setName(name);
    }

    public Index(Table table, String name, boolean unique) {
        this.setTable(table);
        this.setName(name);
        this.setUnique(unique);
    }

    public Index(Table table, String name) {
        this.setTable(table);
        this.setName(name);
    }

    @Override
    public M drop() {
        this.action = ACTION.DDL.INDEX_DROP;
        return (M)((Index)super.drop());
    }

    public boolean isCluster() {
        if (this.getmap && null != this.update) {
            return ((Index)this.update).cluster;
        }
        return this.cluster;
    }

    public LinkedHashMap<String, Integer> getPositions() {
        return this.positions;
    }

    public M setPositions(LinkedHashMap<String, Integer> positions) {
        this.positions = positions;
        return (M)this;
    }

    public M setPosition(String column, Integer position) {
        this.positions.put(column.toUpperCase(), position);
        return (M)this;
    }

    public M setPosition(Column column, Integer position) {
        this.positions.put(column.getName().toUpperCase(), position);
        return (M)this;
    }

    public M addColumn(Column column) {
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        this.columns.put(column.getName().toUpperCase(), column);
        return (M)this;
    }

    public M addColumn(String column) {
        return this.addColumn(new Column(column));
    }

    public M addColumn(String column, String order) {
        return this.addColumn(new Column(column).setOrder(order));
    }

    public M addColumn(String column, String order, int position) {
        this.positions.put(column.toUpperCase(), position);
        return this.addColumn(new Column(column).setOrder(order));
    }

    public M addColumn(String column, int position) {
        this.positions.put(column.toUpperCase(), position);
        return this.addColumn(new Column(column));
    }

    @Override
    public String getName() {
        if (null == this.name) {
            this.name = "index_";
            if (null != this.columns) {
                this.name = this.name + BeanUtil.concat(this.columns.keySet(), "_");
            }
        }
        return this.name;
    }

    public Column getColumn(String name) {
        if (this.getmap && null != this.update) {
            return ((Index)this.update).getColumn(name);
        }
        if (null != this.columns && null != name) {
            return this.columns.get(name.toUpperCase());
        }
        return null;
    }

    public LinkedHashMap<String, Column> getColumns() {
        return this.columns;
    }

    public void setColumns(LinkedHashMap<String, Column> columns) {
        this.columns = columns;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public M setCluster(boolean cluster) {
        if (this.setmap && null != this.update) {
            ((Index)this.update).setCluster(cluster);
            return (M)this;
        }
        this.cluster = cluster;
        return (M)this;
    }

    public boolean isFulltext() {
        if (this.getmap && null != this.update) {
            return ((Index)this.update).fulltext;
        }
        return this.fulltext;
    }

    public M setFulltext(boolean fulltext) {
        if (this.setmap && null != this.update) {
            ((Index)this.update).setFulltext(fulltext);
            return (M)this;
        }
        this.fulltext = fulltext;
        return (M)this;
    }

    public boolean isSpatial() {
        if (this.getmap && null != this.update) {
            return ((Index)this.update).spatial;
        }
        return this.spatial;
    }

    public M setSpatial(boolean spatial) {
        if (this.setmap && null != this.update) {
            ((Index)this.update).setSpatial(spatial);
            return (M)this;
        }
        this.spatial = spatial;
        return (M)this;
    }

    public boolean isPrimary() {
        if (this.getmap && null != this.update) {
            return ((Index)this.update).primary;
        }
        return this.primary;
    }

    public M setPrimary(boolean primary) {
        if (this.setmap && null != this.update) {
            ((Index)this.update).setPrimary(primary);
            return (M)this;
        }
        this.primary = primary;
        if (primary) {
            this.setCluster(true);
            this.setUnique(true);
        }
        return (M)this;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    public boolean equals(Index index) {
        if (null == index) {
            return false;
        }
        String this_define = BeanUtil.concat(this.getColumns().values(), "name", ",", false, true) + ":" + (Object)((Object)this.action);
        String index_define = BeanUtil.concat(index.getColumns().values(), "name", ",", false, true) + ":" + (Object)((Object)index.action);
        return this_define.equalsIgnoreCase(index_define);
    }
}

