/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import org.anyline.metadata.BaseMetadata;

public class Sequence
extends BaseMetadata<Sequence>
implements Serializable {
    protected String keyword = "SEQUENCE";
    private String name;
    private Long min = 0L;
    private Long max;
    private Long last;
    private boolean next = true;
    private Long start = 1L;
    private int increment = 1;
    private int cache = 100;
    private Boolean cycle = false;
    private boolean fetchValueBeforeInsert = false;

    public Sequence() {
    }

    public Sequence(String name) {
        this.setName(name);
    }

    public Sequence(String name, boolean next) {
        this.name = name;
        this.next = next;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String sql() {
        if (this.next) {
            return this.name + "." + "NEXTVAL";
        }
        return this.name + "." + "CURRVAL";
    }

    @Override
    public Sequence setName(String name) {
        if (name.contains(".")) {
            String[] tmps = name.split("\\.");
            name = tmps[0];
            this.next = tmps[1].toUpperCase().contains("NEXT");
        }
        this.name = name;
        return this;
    }

    public boolean isNext() {
        return this.next;
    }

    public void setNext(boolean next) {
        this.next = next;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getCache() {
        return this.cache;
    }

    public void setCache(int cache) {
        this.cache = cache;
    }

    public Long getMin() {
        return this.min;
    }

    public boolean isFetchValueBeforeInsert() {
        return this.fetchValueBeforeInsert;
    }

    public void setFetchValueBeforeInsert(boolean fetchValueBeforeInsert) {
        this.fetchValueBeforeInsert = fetchValueBeforeInsert;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setMin(Long min) {
        this.min = min;
    }

    public Long getMax() {
        return this.max;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public Long getLast() {
        return this.last;
    }

    public void setLast(Long last) {
        this.last = last;
    }

    public Boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(Boolean cycle) {
        this.cycle = cycle;
    }
}

