/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.type;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;

public interface TypeMetadata {
    public static final TypeMetadata ILLEGAL = new TypeMetadata(){

        @Override
        public CATEGORY getCategory() {
            return CATEGORY.NONE;
        }

        @Override
        public CATEGORY_GROUP getCategoryGroup() {
            return CATEGORY_GROUP.NONE;
        }

        @Override
        public String getName() {
            return "ILLEGAL";
        }

        @Override
        public int ignoreLength() {
            return -1;
        }

        @Override
        public int ignorePrecision() {
            return -1;
        }

        @Override
        public int ignoreScale() {
            return -1;
        }

        @Override
        public boolean support() {
            return false;
        }

        @Override
        public void setArray(boolean array) {
        }

        @Override
        public Class compatible() {
            return null;
        }

        @Override
        public Class transfer() {
            return null;
        }

        @Override
        public List<DatabaseType> databaseTypes() {
            return new ArrayList<DatabaseType>();
        }

        @Override
        public Object convert(Object value, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, boolean array) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, boolean array, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Object obj, Field field) {
            return null;
        }

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return null;
        }

        @Override
        public Object read(Object value, Object def, Class clazz, boolean array) {
            return null;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return null;
        }

        @Override
        public Object write(Object value, Object def, boolean array, boolean placeholder) {
            return null;
        }

        @Override
        public Config config() {
            return new Config();
        }
    };
    public static final TypeMetadata NONE = new TypeMetadata(){

        @Override
        public CATEGORY getCategory() {
            return CATEGORY.NONE;
        }

        @Override
        public String getName() {
            return "NONE";
        }

        @Override
        public int ignoreLength() {
            return -1;
        }

        @Override
        public int ignorePrecision() {
            return -1;
        }

        @Override
        public int ignoreScale() {
            return -1;
        }

        @Override
        public boolean support() {
            return false;
        }

        @Override
        public void setArray(boolean array) {
        }

        @Override
        public Config config() {
            return new Config();
        }

        @Override
        public Class compatible() {
            return null;
        }

        @Override
        public Class transfer() {
            return null;
        }

        @Override
        public CATEGORY_GROUP getCategoryGroup() {
            return CATEGORY_GROUP.NONE;
        }

        @Override
        public List<DatabaseType> databaseTypes() {
            return new ArrayList<DatabaseType>();
        }

        @Override
        public Object convert(Object value, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, boolean array) {
            return null;
        }

        @Override
        public Object convert(Object value, Class target, boolean array, Object def) {
            return null;
        }

        @Override
        public Object convert(Object value, Object obj, Field field) {
            return null;
        }

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return null;
        }

        @Override
        public Object read(Object value, Object def, Class clazz, boolean array) {
            return null;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return null;
        }

        @Override
        public Object write(Object value, Object def, boolean array, boolean placeholder) {
            return null;
        }
    };

    default public boolean equals(TypeMetadata metadata) {
        if (null == metadata) {
            return false;
        }
        if (this.getOrigin() == metadata) {
            return true;
        }
        if (this == metadata) {
            return true;
        }
        if (this == metadata.getOrigin()) {
            return true;
        }
        return this.getOrigin() == metadata.getOrigin();
    }

    public CATEGORY getCategory();

    public CATEGORY_GROUP getCategoryGroup();

    public String getName();

    default public TypeMetadata getOrigin() {
        return this;
    }

    public int ignoreLength();

    public int ignorePrecision();

    public int ignoreScale();

    public boolean support();

    default public String formula() {
        return this.getName();
    }

    default public boolean isArray() {
        return false;
    }

    public void setArray(boolean var1);

    public Config config();

    public Class compatible();

    public Class transfer();

    public List<DatabaseType> databaseTypes();

    public Object convert(Object var1, Object var2);

    default public Object convert(Object value, Class target) {
        return this.convert(value, target, false);
    }

    public Object convert(Object var1, Class var2, boolean var3);

    default public Object convert(Object value, Class target, Object def) {
        return this.convert(value, target, false, def);
    }

    public Object convert(Object var1, Class var2, boolean var3, Object var4);

    public Object convert(Object var1, Object var2, Field var3);

    default public Object read(Object value, Object def, Class clazz) {
        return this.read(value, def, clazz, false);
    }

    public Object read(Object var1, Object var2, Class var3, boolean var4);

    default public Object write(Object value, Object def, boolean placeholder) {
        return this.write(value, def, false, placeholder);
    }

    public Object write(Object var1, Object var2, boolean var3, boolean var4);

    public static class Config {
        private String formula;
        private int ignoreLength = -1;
        private int ignorePrecision = -1;
        private int ignoreScale = -1;
        private String[] lengthRefers;
        private String[] precisionRefers;
        private String[] scaleRefers;

        public Config() {
        }

        public Config(String lengthRefer, String precisionRefer, String scaleRefer, int ignoreLength, int ignorePrecision, int ignoreScale) {
            this.setLengthRefer(lengthRefer);
            this.setScaleRefer(scaleRefer);
            this.setPrecisionRefer(precisionRefer);
            this.ignoreLength = ignoreLength;
            this.ignorePrecision = ignorePrecision;
            this.ignoreScale = ignoreScale;
        }

        public Config(String lengthRefer, String precisionRefer, String scaleRefer) {
            this.setLengthRefer(lengthRefer);
            this.setScaleRefer(scaleRefer);
            this.setPrecisionRefer(precisionRefer);
        }

        public Config(int ignoreLength, int ignorePrecision, int ignoreScale) {
            this.ignoreLength = ignoreLength;
            this.ignorePrecision = ignorePrecision;
            this.ignoreScale = ignoreScale;
        }

        public int ignoreLength() {
            return this.ignoreLength;
        }

        public Config setIgnoreLength(int ignoreLength) {
            this.ignoreLength = ignoreLength;
            return this;
        }

        public int ignorePrecision() {
            return this.ignorePrecision;
        }

        public Config setIgnorePrecision(int ignorePrecision) {
            this.ignorePrecision = ignorePrecision;
            return this;
        }

        public int ignoreScale() {
            return this.ignoreScale;
        }

        public Config setIgnoreScale(int ignoreScale) {
            this.ignoreScale = ignoreScale;
            return this;
        }

        public String[] getLengthRefers() {
            return this.lengthRefers;
        }

        public String getLengthRefer() {
            if (null != this.lengthRefers && this.lengthRefers.length > 0) {
                return this.lengthRefers[0];
            }
            return null;
        }

        public Config setLengthRefers(String[] lengthRefers) {
            this.lengthRefers = lengthRefers;
            return this;
        }

        public Config setLengthRefer(String lengthRefer) {
            this.lengthRefers = BasicUtil.isNotEmpty(lengthRefer) ? lengthRefer.split(",") : null;
            return this;
        }

        public String[] getPrecisionRefers() {
            return this.precisionRefers;
        }

        public String getPrecisionRefer() {
            if (null != this.precisionRefers && this.precisionRefers.length > 0) {
                return this.precisionRefers[0];
            }
            return null;
        }

        public Config setPrecisionRefers(String[] precisionRefers) {
            this.precisionRefers = precisionRefers;
            return this;
        }

        public Config setPrecisionRefer(String precisionRefer) {
            this.precisionRefers = BasicUtil.isNotEmpty(precisionRefer) ? precisionRefer.split(",") : null;
            return this;
        }

        public String[] getScaleRefers() {
            return this.scaleRefers;
        }

        public String getScaleRefer() {
            if (null != this.scaleRefers && this.scaleRefers.length > 0) {
                return this.scaleRefers[0];
            }
            return null;
        }

        public Config setScaleRefers(String[] scaleRefers) {
            this.scaleRefers = scaleRefers;
            return this;
        }

        public Config setScaleRefer(String scaleRefer) {
            this.scaleRefers = BasicUtil.isNotEmpty(scaleRefer) ? scaleRefer.split(",") : null;
            return this;
        }

        public String getFormula() {
            return this.formula;
        }

        public void setFormula(String formula) {
            this.formula = formula;
        }

        public Config merge(Config copy) {
            if (null != copy) {
                String formula = copy.getFormula();
                int ignoreLength = copy.ignoreLength();
                int ignorePrecision = copy.ignorePrecision;
                int ignoreScale = copy.ignoreScale();
                if (BasicUtil.isNotEmpty(formula)) {
                    this.formula = formula;
                }
                if (-1 != ignoreLength) {
                    this.ignoreLength = ignoreLength;
                }
                if (-1 != ignorePrecision) {
                    this.ignorePrecision = ignorePrecision;
                }
                if (-1 != ignoreScale) {
                    this.ignoreScale = ignoreScale;
                }
                String[] lengthRefers = copy.getLengthRefers();
                String[] precisionRefers = copy.getPrecisionRefers();
                String[] scaleRefers = copy.getScaleRefers();
                if (null != lengthRefers && lengthRefers.length > 0) {
                    this.lengthRefers = lengthRefers;
                }
                if (null != precisionRefers && precisionRefers.length > 0) {
                    this.precisionRefers = precisionRefers;
                }
                if (null != scaleRefers && scaleRefers.length > 0) {
                    this.scaleRefers = scaleRefers;
                }
            }
            return this;
        }
    }

    public static enum CATEGORY {
        CHAR(CATEGORY_GROUP.STRING, 0, 1, 1),
        TEXT(CATEGORY_GROUP.STRING, 1, 1, 1),
        BOOLEAN(CATEGORY_GROUP.BOOLEAN, 1, 1, 1),
        BYTES(CATEGORY_GROUP.BYTES, 0, 1, 1),
        BLOB(CATEGORY_GROUP.BYTES, 1, 1, 1),
        INT(CATEGORY_GROUP.NUMBER, 0, 1, 1),
        FLOAT(CATEGORY_GROUP.NUMBER, 1, 0, 0),
        DATE(CATEGORY_GROUP.DATETIME, 1, 1, 1),
        TIME(CATEGORY_GROUP.DATETIME, 1, 1, 1),
        DATETIME(CATEGORY_GROUP.DATETIME, 1, 1, 1),
        TIMESTAMP(CATEGORY_GROUP.DATETIME, 1, 1, 1),
        COLLECTION(CATEGORY_GROUP.COLLECTION, 1, 1, 1),
        GEOMETRY(CATEGORY_GROUP.GEOMETRY, 1, 1, 1),
        OTHER(CATEGORY_GROUP.OTHER, 1, 1, 1),
        NONE(CATEGORY_GROUP.NONE, 1, 1, 1);

        private final CATEGORY_GROUP group;
        private final int ignoreLength;
        private final int ignorePrecision;
        private final int ignoreScale;
        private Config config;

        private CATEGORY(CATEGORY_GROUP group, int ignoreLength, int ignorePrecision, int ignoreScale) {
            this.group = group;
            this.ignoreLength = ignoreLength;
            this.ignorePrecision = ignorePrecision;
            this.ignoreScale = ignoreScale;
        }

        public CATEGORY_GROUP group() {
            return this.group;
        }

        public Config config() {
            if (null == this.config) {
                this.config = new Config();
                this.config.setIgnoreLength(this.ignoreLength).setIgnorePrecision(this.ignorePrecision).setIgnoreScale(this.ignoreScale);
            }
            return this.config;
        }
    }

    public static enum CATEGORY_GROUP {
        STRING,
        NUMBER,
        BOOLEAN,
        BYTES,
        DATETIME,
        COLLECTION,
        GEOMETRY,
        OTHER,
        NONE;

    }
}

