/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.ArrayList;
import java.util.List;
import org.anyline.util.NumberUtil;

public class ByteBuffer {
    private List<Byte> list = new ArrayList<Byte>();
    private byte[] bytes;
    private int offset = 0;
    private byte endian = 0;

    public ByteBuffer(int endian) {
        this.endian = (byte)endian;
    }

    public ByteBuffer(int length, int endian) {
        this.bytes = new byte[length];
        this.endian = (byte)endian;
    }

    public ByteBuffer put(byte[] bs) {
        if (null == this.bytes) {
            for (byte b : bs) {
                this.list.add(b);
            }
        } else {
            for (byte b : bs) {
                this.bytes[this.offset++] = b;
            }
        }
        return this;
    }

    public ByteBuffer put(byte b) {
        if (null == this.bytes) {
            this.list.add(b);
        } else {
            this.bytes[this.offset++] = b;
        }
        return this;
    }

    public ByteBuffer put(int b) {
        this.put(NumberUtil.int2bytes(b, this.endian == 0));
        return this;
    }

    public ByteBuffer put(short s) {
        this.put(NumberUtil.short2bytes(s, this.endian == 0));
        return this;
    }

    public ByteBuffer put(long b) {
        this.put(NumberUtil.long2bytes(b, this.endian == 0));
        return this;
    }

    public ByteBuffer put(double b) {
        this.put(NumberUtil.double2bytes(b));
        return this;
    }

    public ByteBuffer offset(int offset) {
        this.offset = offset;
        return this;
    }

    public ByteBuffer(byte[] bytes, int endian) {
        this.bytes = bytes;
    }

    public ByteBuffer(byte[] bytes, int endian, int offset) {
        this.bytes = bytes;
        this.endian = (byte)endian;
        this.offset = offset;
    }

    public byte readByte() {
        byte result = this.bytes[this.offset];
        ++this.offset;
        return result;
    }

    public int readInt() {
        int result = NumberUtil.byte2int(this.bytes, this.offset, 4, this.endian == 0);
        this.offset += 4;
        return result;
    }

    public double readDouble() {
        double result = NumberUtil.byte2double(this.bytes, this.offset);
        this.offset += 8;
        return result;
    }

    public ByteBuffer step(int count) {
        this.offset += count;
        return this;
    }

    public byte[] bytes() {
        if (null == this.bytes) {
            byte[] bts = new byte[this.list.size()];
            int idx = 0;
            for (byte b : this.list) {
                bts[idx++] = b;
            }
            return bts;
        }
        return this.bytes;
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        this.list = list;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte endian() {
        return this.endian;
    }

    public void endian(int endian) {
        this.endian = (byte)endian;
    }

    public ByteBuffer clear() {
        this.list = new ArrayList<Byte>();
        this.bytes = null;
        return this;
    }
}

