/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class DateUtil {
    private static int MaxDate;
    public static final String FORMAT_FULL = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_TIME = "HH:mm:ss";
    public static final int DATE_PART_YEAR = 1;
    public static final int DATE_PART_MONTH = 2;
    public static final int DATE_PART_DATE = 5;
    public static final int DATE_PART_DAY_OF_YEAR = 6;
    public static final int DATE_PART_HOUR = 10;
    public static final int DATE_PART_MINUTE = 12;
    public static final int DATE_PART_SECOND = 13;
    public static final int DATE_PART_MILLISECOND = 14;
    private static final Object calendarLock;
    private static Map<String, ThreadLocal<Calendar>> calendars;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Calendar getCalendar(TimeZone zone, Locale local) {
        if (null == zone) {
            zone = TimeZone.getTimeZone("Asia/Shanghai");
        }
        if (null == local) {
            local = Locale.CHINESE;
        }
        final TimeZone _zone = zone;
        final Locale _local = local;
        String key = zone.getDisplayName() + local.getDisplayName();
        ThreadLocal<Calendar> instance = calendars.get(key);
        if (instance == null) {
            Object object = calendarLock;
            synchronized (object) {
                instance = calendars.get(key);
                if (instance == null) {
                    instance = new ThreadLocal<Calendar>(){

                        @Override
                        protected Calendar initialValue() {
                            return Calendar.getInstance(_zone, _local);
                        }
                    };
                    calendars.put(key, instance);
                }
            }
        }
        return instance.get();
    }

    private static Calendar getCalendar() {
        return DateUtil.getCalendar(null, null);
    }

    public static boolean between(java.util.Date cur, java.util.Date fr, java.util.Date to) {
        return cur.getTime() >= fr.getTime() && cur.getTime() <= to.getTime();
    }

    public static boolean between(String cur, String fr, String to) {
        return DateUtil.between(DateUtil.parse(cur), DateUtil.parse(fr), DateUtil.parse(to));
    }

    public static long diff(int part, java.util.Date fr, java.util.Date to) {
        int time;
        long result = 0L;
        Calendar calendar = DateUtil.getCalendar();
        if (1 == part) {
            calendar.setTime(to);
            time = calendar.get(1);
            calendar.setTime(fr);
            result = time - calendar.get(1);
        }
        if (2 == part) {
            calendar.setTime(to);
            time = calendar.get(1) * 12;
            calendar.setTime(fr);
            time -= calendar.get(1) * 12;
            calendar.setTime(to);
            calendar.setTime(fr);
            result = (time += calendar.get(2)) - calendar.get(2);
        }
        if (3 == part) {
            calendar.setTime(to);
            time = calendar.get(1) * 52;
            calendar.setTime(fr);
            time -= calendar.get(1) * 52;
            calendar.setTime(to);
            calendar.setTime(fr);
            result = (time += calendar.get(3)) - calendar.get(3);
        }
        long ms = to.getTime() - fr.getTime();
        if (6 == part || 5 == part) {
            result = ms / 1000L / 60L / 60L / 24L;
        } else if (10 == part) {
            result = ms / 1000L / 60L / 60L;
        } else if (12 == part) {
            result = ms / 1000L / 60L;
        } else if (13 == part) {
            result = ms / 1000L;
        } else if (14 == part) {
            result = ms;
        }
        return result;
    }

    public static long diff(int part, String fr, String to) {
        return DateUtil.diff(part, DateUtil.parse(fr), DateUtil.parse(to));
    }

    public static long diff(int part, java.util.Date fr) {
        return DateUtil.diff(part, fr, new java.util.Date());
    }

    public static long diff(int part, String fr) {
        return DateUtil.diff(part, DateUtil.parse(fr));
    }

    public static String format(Locale locale, ZoneId zone, java.util.Date date, String format) {
        if (null == date || null == format) {
            return null;
        }
        LocalDateTime datetime = DateUtil.localDateTime(date, zone);
        return datetime.format(DateTimeFormatter.ofPattern(format, locale));
    }

    public static String format(Locale locale, ZoneId zone, Long date, String format) {
        if (null == date || null == format) {
            return null;
        }
        return DateUtil.format(locale, zone, DateUtil.parse(date), format);
    }

    public static String format(Locale locale, ZoneId zone) {
        return DateUtil.format(locale, zone, new java.util.Date(), FORMAT_DATE_TIME);
    }

    public static String format(Locale locale, ZoneId zone, String format) {
        return DateUtil.format(locale, zone, new java.util.Date(), format);
    }

    public static String format(Locale locale, ZoneId zone, java.util.Date date) {
        return DateUtil.format(locale, zone, date, FORMAT_FULL);
    }

    public static String format(Locale locale, ZoneId zone, Long date) {
        return DateUtil.format(locale, zone, date, FORMAT_FULL);
    }

    public static String format(Locale locale, ZoneId zone, String date, String format) {
        java.util.Date d = DateUtil.parse(date);
        return DateUtil.format(locale, zone, d, format);
    }

    public static String format(Locale locale, java.util.Date date, String format) {
        return DateUtil.format(locale, ZoneId.systemDefault(), date, format);
    }

    public static String format(Locale locale, Long date, String format) {
        return DateUtil.format(locale, ZoneId.systemDefault(), date, format);
    }

    public static String format(Locale locale) {
        return DateUtil.format(locale, ZoneId.systemDefault());
    }

    public static String format(Locale locale, String format) {
        return DateUtil.format(locale, ZoneId.systemDefault(), format);
    }

    public static String format(Locale locale, java.util.Date date) {
        return DateUtil.format(locale, ZoneId.systemDefault(), date);
    }

    public static String format(Locale locale, Long date) {
        return DateUtil.format(locale, ZoneId.systemDefault(), date);
    }

    public static String format(Locale locale, String date, String format) {
        return DateUtil.format(locale, ZoneId.systemDefault(), date, format);
    }

    public static String format(java.util.Date date, String format) {
        return DateUtil.format(Locale.getDefault(), ZoneId.systemDefault(), date, format);
    }

    public static String format(Long date, String format) {
        return DateUtil.format(Locale.getDefault(), ZoneId.systemDefault(), date, format);
    }

    public static String format() {
        return DateUtil.format(Locale.getDefault(), ZoneId.systemDefault());
    }

    public static String format(String format) {
        return DateUtil.format(Locale.getDefault(), ZoneId.systemDefault(), format);
    }

    public static String format(java.util.Date date) {
        return DateUtil.format(Locale.getDefault(), ZoneId.systemDefault(), date);
    }

    public static String format(Long date) {
        return DateUtil.format(Locale.getDefault(), ZoneId.systemDefault(), date);
    }

    public static String format(String date, String format) {
        return DateUtil.format(Locale.getDefault(), ZoneId.systemDefault(), date, format);
    }

    public static int convertMinute(String hm) {
        int minute = -1;
        if (!hm.contains(":")) {
            return minute;
        }
        String[] sps = hm.split(":");
        int h = BasicUtil.parseInt(sps[0], 0);
        int m = BasicUtil.parseInt(sps[1], 0);
        minute = h * 60 + m;
        return minute;
    }

    public static int convertMinute() {
        String hm = DateUtil.format("HH:mm");
        return DateUtil.convertMinute(hm);
    }

    public static String convertMinute(int minute) {
        String time = "";
        int h = minute / 60;
        int m = minute % 60;
        if (h < 10) {
            time = time + "0";
        }
        time = time + h + ":";
        if (m < 10) {
            time = time + "0";
        }
        time = time + m;
        return time;
    }

    public static String getWeek(java.util.Date date) {
        return DateUtil.format(date, "EEEE");
    }

    public static String getWeek(String date) {
        return DateUtil.getWeek(DateUtil.parse(date));
    }

    public static java.util.Date getFirstDayOfWeek(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.set(7, 1);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDayOfWeek(String date) {
        return DateUtil.getFirstDayOfWeek(DateUtil.parse(date));
    }

    public static java.util.Date getFirstDayOfWeek() {
        return DateUtil.getFirstDayOfWeek(new java.util.Date());
    }

    public static java.util.Date getFirstDayOfNextWeek(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(3, 1);
        calendar.set(7, 1);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDayOfNextWeek(String date) {
        return DateUtil.getFirstDayOfNextWeek(DateUtil.parse(date));
    }

    public static java.util.Date getFirstDayOfNextWeek() {
        return DateUtil.getFirstDayOfNextWeek(new java.util.Date());
    }

    public static java.util.Date getFirstDayOfPreviousWeek(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(3, -1);
        calendar.set(7, 1);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDayOfPreviousWeek(String date) {
        return DateUtil.getFirstDayOfPreviousWeek(DateUtil.parse(date));
    }

    public static java.util.Date getFirstDayOfPreviousWeek() {
        return DateUtil.getFirstDayOfPreviousWeek(new java.util.Date());
    }

    public static java.util.Date getLastDayOfWeek(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.set(7, 7);
        return calendar.getTime();
    }

    public static java.util.Date getLastDayOfWeek(String date) {
        return DateUtil.getLastDayOfWeek(DateUtil.parse(date));
    }

    public static java.util.Date getLastDayOfWeek() {
        return DateUtil.getLastDayOfWeek(new java.util.Date());
    }

    public static java.util.Date getLastDayOfNextWeek(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(3, 1);
        calendar.set(7, 7);
        return calendar.getTime();
    }

    public static java.util.Date getLastDayOfNextWeek(String date) {
        return DateUtil.getLastDayOfNextWeek(DateUtil.parse(date));
    }

    public static java.util.Date getLastDayOfNextWeek() {
        return DateUtil.getLastDayOfNextWeek(new java.util.Date());
    }

    public static java.util.Date getLastDayOfPreviousWeek(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(3, -1);
        calendar.set(7, 7);
        return calendar.getTime();
    }

    public static java.util.Date getLastDayOfPreviousWeek(String date) {
        return DateUtil.getLastDayOfPreviousWeek(DateUtil.parse(date));
    }

    public static java.util.Date getLastDayOfPreviousWeek() {
        return DateUtil.getLastDayOfPreviousWeek(new java.util.Date());
    }

    public static java.util.Date getFirstDayOfMonth(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDayOfMonth(String date) {
        return DateUtil.getFirstDayOfMonth(DateUtil.parse(date));
    }

    public static java.util.Date getFirstDayOfMonth() {
        return DateUtil.getFirstDayOfMonth(new java.util.Date());
    }

    public static java.util.Date getFirstDayOfNextMonth(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDayOfNextMonth(String date) {
        return DateUtil.getFirstDayOfNextMonth(DateUtil.parse(date));
    }

    public static java.util.Date getFirstDayOfNextMonth() {
        return DateUtil.getFirstDayOfNextMonth(new java.util.Date());
    }

    public static java.util.Date getFirstDayOfPreviousMonth(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, -1);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDayOfPreviousMonth(String date) {
        return DateUtil.getFirstDayOfPreviousMonth(DateUtil.parse(date));
    }

    public static java.util.Date getFirstDayOfPreviousMonth() {
        return DateUtil.getFirstDayOfPreviousMonth(new java.util.Date());
    }

    public static java.util.Date getLastDayOfMonth(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTimeInMillis(date.getTime() + 100000L);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static java.util.Date getLastDayOfMonth(String date) {
        return DateUtil.getLastDayOfMonth(DateUtil.parse(date));
    }

    public static java.util.Date getLastDayOfMonth() {
        return DateUtil.getLastDayOfMonth(new java.util.Date());
    }

    public static java.util.Date getLastDayOfPreviousMonth(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.roll(5, -1);
        return calendar.getTime();
    }

    public static java.util.Date getLastDayOfPreviousMonth(String date) {
        return DateUtil.getLastDayOfPreviousMonth(DateUtil.parse(date));
    }

    public static java.util.Date getLastDayOfPreviousMonth() {
        return DateUtil.getLastDayOfPreviousMonth(new java.util.Date());
    }

    public static java.util.Date getLastDayOfNextMonth(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.roll(5, -1);
        return calendar.getTime();
    }

    public static java.util.Date getLastDayOfNextMonth(String date) {
        return DateUtil.getLastDayOfNextMonth(DateUtil.parse(date));
    }

    public static java.util.Date getLastDayOfNextMonth() {
        return DateUtil.getLastDayOfNextMonth(new java.util.Date());
    }

    public static java.util.Date getCurrentWeekday(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        int mondayPlus = DateUtil.getMondayPlus(date);
        calendar.setTime(date);
        calendar.add(5, mondayPlus + 6);
        return calendar.getTime();
    }

    public static java.util.Date getCurrentWeekday(String date) {
        return DateUtil.getCurrentWeekday(DateUtil.parse(date));
    }

    public static java.util.Date getCurrentWeekday() {
        return DateUtil.getCurrentWeekday(new java.util.Date());
    }

    public static int getMondayPlus(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7) - 1;
        if (dayOfWeek == 1) {
            return 0;
        }
        return 1 - dayOfWeek;
    }

    public static int getMondayPlus() {
        return DateUtil.getMondayPlus(new java.util.Date());
    }

    public static java.util.Date getMondayOFWeek(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        int mondayPlus = DateUtil.getMondayPlus(date);
        calendar.setTime(date);
        calendar.add(5, mondayPlus);
        return calendar.getTime();
    }

    public static java.util.Date getMondayOFWeek(String date) {
        return DateUtil.getMondayOFWeek(DateUtil.parse(date));
    }

    public static java.util.Date getMondayOFWeek() {
        return DateUtil.getMondayOFWeek(new java.util.Date());
    }

    public static java.util.Date getNextMonday(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        int mondayPlus = DateUtil.getMondayPlus(date);
        calendar.setTime(date);
        calendar.add(5, mondayPlus + 7);
        return calendar.getTime();
    }

    public static java.util.Date getNextMonday(String date) {
        return DateUtil.getNextMonday(DateUtil.parse(date));
    }

    public static java.util.Date getNextMonday() {
        return DateUtil.getNextMonday(new java.util.Date());
    }

    public static java.util.Date getNextSunday(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        int mondayPlus = DateUtil.getMondayPlus(date);
        calendar.setTime(date);
        calendar.add(5, mondayPlus + 7 + 6);
        return calendar.getTime();
    }

    public static java.util.Date getNextSunday(String date) {
        return DateUtil.getNextSunday(DateUtil.parse(date));
    }

    public static java.util.Date getNextSunday() {
        return DateUtil.getNextSunday(new java.util.Date());
    }

    public static int getMonthPlus(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        int monthOfNumber = calendar.get(5);
        calendar.set(5, 1);
        calendar.roll(5, -1);
        MaxDate = calendar.get(5);
        if (monthOfNumber == 1) {
            return -MaxDate;
        }
        return 1 - monthOfNumber;
    }

    public static java.util.Date getNextYearEnd(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(1, 1);
        calendar.set(6, 1);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    public static java.util.Date getNextYearEnd(String date) {
        return DateUtil.getNextYearEnd(DateUtil.parse(date));
    }

    public static java.util.Date getNextYearEnd() {
        return DateUtil.getNextYearEnd(new java.util.Date());
    }

    public static java.util.Date getNextYearFirst(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(1, 1);
        calendar.set(6, 1);
        return calendar.getTime();
    }

    public static java.util.Date getNextYearFirst(String date) {
        return DateUtil.getNextYearFirst(DateUtil.parse(date));
    }

    public static java.util.Date getNextYearFirst() {
        return DateUtil.getNextYearFirst(new java.util.Date());
    }

    public static int countDaysOfYear(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.set(6, 1);
        calendar.roll(6, -1);
        return calendar.get(6);
    }

    public static int countDaysOfYear(int year) {
        java.util.Date date = DateUtil.parse(year + "-01-01");
        return DateUtil.countDaysOfYear(date);
    }

    public static int countDaysOfYear() {
        return DateUtil.countDaysOfYear(new java.util.Date());
    }

    public static int countDaysOfMonth(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        return calendar.get(5);
    }

    public static int countDaysOfMonth(String ym) {
        java.util.Date date = DateUtil.parse(ym + "-01");
        return DateUtil.countDaysOfMonth(date);
    }

    public static int countDaysOfMonth() {
        return DateUtil.countDaysOfMonth(new java.util.Date());
    }

    private static int getYearPlus(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        int yearOfNumber = calendar.get(6);
        calendar.set(6, 1);
        calendar.roll(6, -1);
        int MaxYear = calendar.get(6);
        if (yearOfNumber == 1) {
            return -MaxYear;
        }
        return 1 - yearOfNumber;
    }

    public static java.util.Date getFirstDayOfYear(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        int yearPlus = DateUtil.getYearPlus(date);
        calendar.setTime(date);
        calendar.add(5, yearPlus);
        return calendar.getTime();
    }

    public static java.util.Date getFirstDayOfYear(String date) {
        return DateUtil.getFirstDayOfYear(DateUtil.parse(date));
    }

    public static java.util.Date getFirstDayOfYear() {
        return DateUtil.getFirstDayOfYear(new java.util.Date());
    }

    public static String getCurrentYearEnd(java.util.Date date) {
        return DateUtil.format(date, "yyyy") + "-12-31";
    }

    public static String getCurrentYearEnd(String date) {
        return DateUtil.getCurrentYearEnd(DateUtil.parse(date));
    }

    public static String getCurrentYearEnd() {
        return DateUtil.getCurrentYearEnd(new java.util.Date());
    }

    public static String getPreviousYearFirst(java.util.Date date) {
        String years = DateUtil.format(date, "yyyy");
        return Integer.parseInt(years) - 1 + "-01-01";
    }

    public static String getPreviousYearFirst(String date) {
        return DateUtil.getPreviousYearFirst(DateUtil.parse(date));
    }

    public static String getPreviousYearFirst() {
        return DateUtil.getPreviousYearFirst(new java.util.Date());
    }

    public static int getLastDayOfMonth(int year, int month) {
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            return 31;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (DateUtil.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 0;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static java.util.Date parse(String date, String format) throws RuntimeException {
        DateTimeFormatter formatter = null;
        formatter = null != format || format.length() == 0 ? DateTimeFormatter.ofPattern(format) : DateTimeFormatter.ISO_LOCAL_TIME;
        if (format.toUpperCase().contains("HH")) {
            if (format.toUpperCase().contains("D")) {
                return DateUtil.parse(LocalDateTime.parse(date, formatter));
            }
            return DateUtil.parse(LocalTime.parse(date, formatter));
        }
        return DateUtil.parse(LocalDate.parse(date, formatter));
    }

    public static java.util.Date parse(String date, String format, java.util.Date def) {
        java.util.Date result = null;
        try {
            result = DateUtil.parse(date, format);
        }
        catch (Exception e) {
            result = def;
        }
        return result;
    }

    public static java.util.Date parse(Long value) {
        java.util.Date date = new java.util.Date(value);
        return date;
    }

    public static java.util.Date parse(Date value) {
        java.util.Date date = new java.util.Date(value.getTime());
        return date;
    }

    public static java.util.Date parse(Time value) {
        java.util.Date date = new java.util.Date(value.getTime());
        return date;
    }

    public static java.util.Date parse(LocalDate value) {
        java.util.Date date = java.util.Date.from(value.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return date;
    }

    public static java.util.Date parse(LocalDateTime value) {
        java.util.Date date = java.util.Date.from(value.atZone(ZoneId.systemDefault()).toInstant());
        return date;
    }

    public static java.util.Date parse(LocalTime value) {
        java.util.Date date = java.util.Date.from(value.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        return date;
    }

    public static java.util.Date parse(Timestamp value) {
        java.util.Date date = new java.util.Date(value.getTime());
        return date;
    }

    public static java.util.Date parse(Object value) throws RuntimeException {
        java.util.Date date = null;
        if (null != value) {
            if (value.getClass() == java.util.Date.class) {
                date = (java.util.Date)value;
            } else if (value instanceof Timestamp) {
                date = DateUtil.parse((Timestamp)value);
            } else if (value instanceof Date) {
                date = DateUtil.parse((Date)value);
            } else if (value instanceof Time) {
                date = DateUtil.parse((Time)value);
            } else if (value instanceof Long) {
                date = DateUtil.parse((Long)value);
            } else if (value instanceof LocalDate) {
                date = DateUtil.parse((LocalDate)value);
            } else if (value instanceof LocalTime) {
                date = DateUtil.parse((LocalTime)value);
            } else if (value instanceof LocalDateTime) {
                date = DateUtil.parse((LocalDateTime)value);
            } else if (value instanceof String) {
                if (BasicUtil.isNumber(value)) {
                    Long timestamp = BasicUtil.parseLong(value, 0L);
                    date = DateUtil.parse(timestamp);
                } else {
                    date = DateUtil.parse((String)value);
                }
            }
        }
        return date;
    }

    public static java.util.Date parse(Object value, java.util.Date def) {
        java.util.Date result = null;
        try {
            result = DateUtil.parse(value);
        }
        catch (Exception e) {
            result = def;
        }
        return result;
    }

    public static java.util.Date parse(String value, java.util.Date def) {
        java.util.Date result = null;
        try {
            result = DateUtil.parse(value);
        }
        catch (Exception e) {
            result = def;
        }
        return result;
    }

    public static java.util.Date parse(String str) throws RuntimeException {
        if (BasicUtil.isEmpty((Object)str)) {
            return null;
        }
        if ((str = str.trim()).length() <= 5 && !RegularUtil.match(str, Regular.PATTERN.DATE_TIME.getCode(), Regular.MATCH_MODE.MATCH)) {
            return null;
        }
        if (str.contains("T")) {
            if (str.contains("+") || str.contains("Z")) {
                return java.util.Date.from(OffsetDateTime.parse(str).toInstant());
            }
            str = str.replace("T", " ");
        }
        java.util.Date date = null;
        String format = FORMAT_FULL;
        if (!str.contains(".")) {
            format = FORMAT_DATE_TIME;
        } else {
            String[] tmp = str.split("\\.");
            str = tmp[0] + "." + BasicUtil.fillChar(tmp[1], 3);
        }
        if (!str.contains(":")) {
            str = str + " 00:00:00";
        } else if (!str.contains(" ")) {
            str = DateUtil.format(FORMAT_DATE) + " " + str;
        }
        if (BasicUtil.charCount(str, ":") == 1) {
            str = str + ":00";
        }
        if (str.contains("/")) {
            format = format.replace("-", "/");
        }
        if (!str.contains("-") && !str.contains("/")) {
            format = format.replace("-", "").replace("/", "");
        }
        try {
            date = DateUtil.parse(str, format);
        }
        catch (Exception e) {
            try {
                date = DateUtil.parse(str, (String)null);
            }
            catch (Exception excep) {
                date = null;
            }
        }
        return date;
    }

    public static boolean isDate(String str) {
        try {
            return DateUtil.parse(str) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static java.util.Date yesterday() {
        return DateUtil.addDay(-1);
    }

    public static java.util.Date tomorrow() {
        return DateUtil.addDay(1);
    }

    public static java.util.Date now() {
        return new java.util.Date(System.currentTimeMillis());
    }

    public static java.util.Date addDay(int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(new java.util.Date());
        calendar.add(6, value);
        return calendar.getTime();
    }

    public static java.util.Date addDay(java.util.Date date, int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(6, value);
        return calendar.getTime();
    }

    public static String addDay(String date, int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(DateUtil.parse(date));
        calendar.add(6, value);
        return DateUtil.format(calendar.getTime(), FORMAT_DATE);
    }

    public static java.util.Date addMonth(int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(new java.util.Date());
        calendar.add(2, value);
        return calendar.getTime();
    }

    public static java.util.Date addMonth(java.util.Date date, int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(2, value);
        return calendar.getTime();
    }

    public static java.util.Date addMonth(String date, int value) {
        return DateUtil.addMonth(DateUtil.parse(date), value);
    }

    public static java.util.Date addYear(int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(new java.util.Date());
        calendar.add(1, value);
        return calendar.getTime();
    }

    public static java.util.Date getDateOfWeek(int idx, java.util.Date date) {
        java.util.Date result = null;
        Calendar cal = DateUtil.getCalendar();
        cal.setTime(date);
        int day_of_week = cal.get(7) - idx;
        cal.add(5, -day_of_week);
        result = cal.getTime();
        return result;
    }

    public static java.util.Date getDateOfWeek(int idx) {
        return DateUtil.getDateOfWeek(idx, new java.util.Date());
    }

    public static int getDayOfWeek(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(7) - 1;
    }

    public static int getDayOfWeek() {
        return DateUtil.getDayOfWeek(new java.util.Date());
    }

    public static int getDayOfWeek(String date) {
        return DateUtil.getDayOfWeek(DateUtil.parse(date));
    }

    public static List<java.util.Date> getDays(java.util.Date fr, java.util.Date to) {
        ArrayList<java.util.Date> list = new ArrayList<java.util.Date>();
        list.add(fr);
        while (DateUtil.diff(5, fr = DateUtil.addDay(fr, 1), to) >= 0L) {
            list.add(fr);
        }
        return list;
    }

    public static List<String> getMonths(String fr, String to) {
        ArrayList<String> list = new ArrayList<String>();
        if (fr.length() < 10) {
            fr = fr + "-01";
        }
        if (to.length() < 10) {
            to = to + "-01";
        }
        java.util.Date ymd = DateUtil.parse(fr);
        java.util.Date last = DateUtil.parse(to);
        list.add(DateUtil.format(ymd, "yyyy-MM"));
        while (DateUtil.diff(2, ymd = DateUtil.addMonth(ymd, 1), last) >= 0L) {
            list.add(DateUtil.format(ymd, "yyyy-MM"));
        }
        return list;
    }

    public static List<java.util.Date> getDaysOfYear(int year) {
        return DateUtil.getDaysOfYear(DateUtil.parse(year + "-01-01"));
    }

    public static List<java.util.Date> getDaysOfYear(String year) {
        String ymd = year + "-01-01";
        if (year.length() > 4) {
            ymd = year;
        }
        return DateUtil.getDaysOfYear(DateUtil.parse(ymd));
    }

    public static List<java.util.Date> getDaysOfYear(java.util.Date date) {
        ArrayList<java.util.Date> list = new ArrayList<java.util.Date>();
        java.util.Date start = DateUtil.getFirstDayOfYear(date);
        int qty = DateUtil.countDaysOfYear(date);
        for (int i = 0; i < qty; ++i) {
            list.add(DateUtil.addDay(start, i));
        }
        return list;
    }

    public static List<java.util.Date> getDaysOfMonth(String ym) {
        String ymd = ym + "-01";
        if (ym.length() > 7) {
            ymd = ym;
        }
        return DateUtil.getDaysOfMonth(DateUtil.parse(ymd));
    }

    public static List<java.util.Date> getDaysOfMonth(java.util.Date ym) {
        ArrayList<java.util.Date> list = new ArrayList<java.util.Date>();
        java.util.Date start = DateUtil.getFirstDayOfMonth(ym);
        int qty = DateUtil.countDaysOfMonth(ym);
        for (int i = 0; i < qty; ++i) {
            java.util.Date date = DateUtil.addDay(start, i);
            list.add(date);
        }
        return list;
    }

    public static List<java.util.Date> getDaysOfWeek(int year, int week) {
        Calendar calendar = DateUtil.getCalendar();
        ArrayList<java.util.Date> list = new ArrayList<java.util.Date>();
        calendar.setTime(new java.util.Date());
        calendar.set(1, year);
        calendar.set(3, week);
        calendar.set(7, 1);
        java.util.Date start = DateUtil.getFirstDayOfNextWeek(calendar.getTime());
        for (int i = 0; i < 7; ++i) {
            java.util.Date date = DateUtil.addDay(start, i);
            list.add(date);
        }
        return list;
    }

    public static List<java.util.Date> getDaysOfWeek(String date) {
        return DateUtil.getDaysOfWeek(DateUtil.parse(date));
    }

    public static List<java.util.Date> getDaysOfWeek(java.util.Date date) {
        ArrayList<java.util.Date> list = new ArrayList<java.util.Date>();
        java.util.Date start = DateUtil.getFirstDayOfWeek(date);
        for (int i = 0; i < 7; ++i) {
            list.add(DateUtil.addDay(start, i));
        }
        return list;
    }

    public static List<String> getDays(String fr, String to) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(fr);
        while (DateUtil.diff(5, fr = DateUtil.addDay(fr, 1), to) >= 0L) {
            list.add(fr);
        }
        return list;
    }

    public static String max(String ... dates) {
        String result = null;
        if (null != dates) {
            for (String date : dates) {
                if (BasicUtil.isEmpty(result)) {
                    result = date;
                    continue;
                }
                if (!BasicUtil.isNotEmpty(date) || DateUtil.diff(13, result, date) <= 0L) continue;
                result = date;
            }
        }
        return result;
    }

    public static String min(String ... dates) {
        String result = null;
        if (null != dates) {
            for (String date : dates) {
                if (BasicUtil.isEmpty(result)) {
                    result = date;
                    continue;
                }
                if (!BasicUtil.isNotEmpty(date) || DateUtil.diff(13, result, date) >= 0L) continue;
                result = date;
            }
        }
        return result;
    }

    public static java.util.Date max(java.util.Date ... dates) {
        java.util.Date result = null;
        if (null != dates) {
            for (java.util.Date date : dates) {
                if (null == result) {
                    result = date;
                    continue;
                }
                if (null == date || DateUtil.diff(13, result, date) <= 0L) continue;
                result = date;
            }
        }
        return result;
    }

    public static java.util.Date min(java.util.Date ... dates) {
        java.util.Date result = null;
        if (null != dates) {
            for (java.util.Date date : dates) {
                if (null == result) {
                    result = date;
                    continue;
                }
                if (null == date || DateUtil.diff(13, result, date) >= 0L) continue;
                result = date;
            }
        }
        return result;
    }

    public static int getWeekOfYear(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static int getWeekOfYear() {
        return DateUtil.getWeekOfYear(new java.util.Date());
    }

    public static java.util.Date addYear(java.util.Date date, int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(1, value);
        return calendar.getTime();
    }

    public static java.util.Date addYear(String date, int value) {
        return DateUtil.addYear(DateUtil.parse(date), value);
    }

    public static java.util.Date addHour(int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(new java.util.Date());
        calendar.add(11, value);
        return calendar.getTime();
    }

    public static java.util.Date addHour(java.util.Date date, int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(11, value);
        return calendar.getTime();
    }

    public static java.util.Date addHour(String date, int value) {
        return DateUtil.addHour(DateUtil.parse(date), value);
    }

    public static java.util.Date addMinute(int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(new java.util.Date());
        calendar.add(12, value);
        return calendar.getTime();
    }

    public static java.util.Date addMinute(java.util.Date date, int value) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        calendar.add(12, value);
        return calendar.getTime();
    }

    public static java.util.Date addMinute(String date, int value) {
        return DateUtil.addMinute(DateUtil.parse(date), value);
    }

    public static int year(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int year() {
        return DateUtil.year(new java.util.Date());
    }

    public static int year(String date) {
        return DateUtil.year(DateUtil.parse(date));
    }

    public static int month(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int month(String date) {
        return DateUtil.month(DateUtil.parse(date));
    }

    public static int month() {
        return DateUtil.month(new java.util.Date());
    }

    public static int dayOfWeek(java.util.Date date) {
        return DateUtil.getDayOfWeek(date);
    }

    public static int dayOfWeek() {
        return DateUtil.getDayOfWeek();
    }

    public static int dayOfWeek(String date) {
        return DateUtil.getDayOfWeek(date);
    }

    public static int dayOfMonth(java.util.Date date) {
        return DateUtil.getDayOfMonth(date);
    }

    public static int dayOfMonth(String date) {
        return DateUtil.getDayOfMonth(date);
    }

    public static int dayOfMonth() {
        return DateUtil.getDayOfMonth();
    }

    public static int getDayOfMonth(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayOfMonth(String date) {
        return DateUtil.getDayOfMonth(DateUtil.parse(date));
    }

    public static int getDayOfMonth() {
        return DateUtil.getDayOfMonth(new java.util.Date());
    }

    public static int day(java.util.Date date) {
        return DateUtil.dayOfMonth(date);
    }

    public static int day() {
        return DateUtil.day(new java.util.Date());
    }

    public static int dayOfYear(java.util.Date date) {
        return DateUtil.getDayOfYear(date);
    }

    public static int dayOfYear(String date) {
        return DateUtil.getDayOfYear(date);
    }

    public static int dayOfYear() {
        return DateUtil.getDayOfYear();
    }

    public static int getDayOfYear(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(6);
    }

    public static int getDayOfYear(String date) {
        return DateUtil.getDayOfYear(DateUtil.parse(date));
    }

    public static int getDayOfYear() {
        return DateUtil.dayOfYear(new java.util.Date());
    }

    public static int hour(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int hour() {
        return DateUtil.hour(new java.util.Date());
    }

    public static int minute(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int minute() {
        return DateUtil.minute(new java.util.Date());
    }

    public static int second(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static int second() {
        return DateUtil.second(new java.util.Date());
    }

    public static int compare(java.util.Date date1, java.util.Date date2) {
        long _date2;
        long _date1 = date1.getTime();
        if (_date1 > (_date2 = date2.getTime())) {
            return 1;
        }
        if (_date1 == _date2) {
            return 0;
        }
        return -1;
    }

    public static int compare(String fr, String to) {
        return DateUtil.compare(DateUtil.parse(fr), DateUtil.parse(to));
    }

    public static boolean isAm(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(9) == 0;
    }

    public static boolean isAm() {
        return DateUtil.isAm(new java.util.Date());
    }

    public static boolean isPm(java.util.Date date) {
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date);
        return calendar.get(9) == 1;
    }

    public static boolean isPm() {
        return DateUtil.isPm(new java.util.Date());
    }

    public static String conversion(double src) {
        return DateUtil.conversion((long)src);
    }

    public static String conversion(long src) {
        String result = "";
        long s = 0L;
        long m = 0L;
        long h = 0L;
        long d = 0L;
        long ms = 0L;
        d = src / 1000L / 60L / 60L / 24L;
        h = (src - d * 24L * 60L * 60L * 1000L) / 1000L / 60L / 60L;
        m = (src - d * 24L * 60L * 60L * 1000L - h * 60L * 60L * 1000L) / 1000L / 60L;
        s = (src - d * 24L * 60L * 60L * 1000L - h * 60L * 60L * 1000L - m * 60L * 1000L) / 1000L;
        ms = src % 1000L;
        if (d > 0L) {
            result = result + d + "\u5929";
        }
        if (h > 0L || d > 0L && m + s + ms > 0L) {
            result = result + h + "\u65f6";
        }
        if (m > 0L || h > 0L && s + ms > 0L || d > 0L && s + ms > 0L) {
            result = result + m + "\u5206";
        }
        if (s > 0L || m > 0L && ms > 0L || h > 0L && ms > 0L || d > 0L && ms > 0L) {
            result = ms == 0L ? result + s + "\u79d2" : result + s + "." + BasicUtil.fillChar(ms + "", 3) + "\u79d2";
        }
        if (src < 1000L && ms > 0L) {
            result = result + ms + "\u6beb\u79d2";
        }
        if (src <= 0L) {
            result = "0\u6beb\u79d2";
        }
        return result;
    }

    public static LocalDateTime localDateTime(java.util.Date date, ZoneId zone) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(zone).toLocalDateTime();
    }

    public static OffsetDateTime offsetDateTime(java.util.Date date) {
        return OffsetDateTime.of(DateUtil.localDateTime(date), ZoneOffset.UTC);
    }

    public static LocalDateTime localDateTime(java.util.Date date) {
        return DateUtil.localDateTime(date, ZoneId.systemDefault());
    }

    public static LocalTime localTime(java.util.Date date, ZoneId zone) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(zone).toLocalTime();
    }

    public static LocalTime localTime(java.util.Date date) {
        return DateUtil.localTime(date, ZoneId.systemDefault());
    }

    public static LocalDate localDate(java.util.Date date, ZoneId zone) {
        if (null == date) {
            return null;
        }
        return date.toInstant().atZone(zone).toLocalDate();
    }

    public static LocalDate localDate(java.util.Date date) {
        return DateUtil.localDate(date, ZoneId.systemDefault());
    }

    public static LocalDateTime localDateTime(Long timestamp, ZoneId zone) {
        return DateUtil.localDateTime(DateUtil.parse(timestamp), zone);
    }

    public static LocalDateTime localDateTime(Long timestamp) {
        return DateUtil.localDateTime(DateUtil.parse(timestamp), ZoneId.systemDefault());
    }

    public static LocalTime localTime(Long timestamp, ZoneId zone) {
        return DateUtil.localTime(DateUtil.parse(timestamp), zone);
    }

    public static LocalTime localTime(Long timestamp) {
        return DateUtil.localTime(timestamp, ZoneId.systemDefault());
    }

    public static LocalDate localDate(Long timestamp, ZoneId zone) {
        return DateUtil.localDate(DateUtil.parse(timestamp), zone);
    }

    public static LocalDate localDate(Long timestamp) {
        return DateUtil.localDate(timestamp, ZoneId.systemDefault());
    }

    public static Date sqlDate(java.util.Date date) {
        Date result = null;
        if (null != date) {
            result = new Date(date.getTime());
        }
        return result;
    }

    public static Date sqlDate(Timestamp date) {
        Date result = null;
        if (null != date) {
            result = new Date(date.getTime());
        }
        return result;
    }

    public static Time sqlTime(java.util.Date date) {
        Time result = null;
        if (null != date) {
            result = Time.valueOf(DateUtil.format(date, FORMAT_TIME));
        }
        return result;
    }

    public static Timestamp sqlTimestamp(java.util.Date date) {
        Timestamp result = new Timestamp(date.getTime());
        return result;
    }

    public static Date sqlDate(LocalDate date) {
        Date result = null;
        if (null != date) {
            result = Date.valueOf(date);
        }
        return result;
    }

    public static YearMonth yearMonth(java.util.Date date) {
        YearMonth yearMonth = YearMonth.of(DateUtil.year(date), DateUtil.month(date));
        return yearMonth;
    }

    static {
        calendarLock = new Object();
        calendars = new HashMap<String, ThreadLocal<Calendar>>();
    }
}

