/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.anyline.util.ConfigTable;
import org.anyline.util.FileUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18NUtil {
    static final Logger log = LoggerFactory.getLogger(I18NUtil.class);
    public static final String defaultLang = "cn";
    private static Map<String, Map<String, String>> messages;

    private static void init() {
        String dir = ConfigTable.getString("I18N_MESSAGE_DIR");
        if (null == dir) {
            return;
        }
        List<File> files = FileUtil.getAllChildrenFile(new File(ConfigTable.getWebRoot(), dir), "xml");
        messages = new Hashtable<String, Map<String, String>>();
        SAXReader reader = new SAXReader();
        for (File file : files) {
            try {
                Document document = reader.read(file);
                Element root = document.getRootElement();
                Iterator itrProperty = root.elementIterator("property");
                while (itrProperty.hasNext()) {
                    Element propertyElement = (Element)itrProperty.next();
                    String key = propertyElement.attributeValue("key");
                    Iterator itrItem = propertyElement.elementIterator("item");
                    while (itrItem.hasNext()) {
                        Element itemElement = (Element)itrItem.next();
                        String lang = itemElement.attributeValue("lang");
                        String value = itemElement.getTextTrim();
                        Map<String, String> map = messages.get(lang);
                        if (null == map) {
                            map = new Hashtable<String, String>();
                            messages.put(lang, map);
                        }
                        map.put(key, value);
                    }
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String get(String lang, String key) {
        Map<String, String> map = messages.get(lang);
        String value = null;
        if (null != map) {
            value = map.get(key);
        }
        return value;
    }

    static {
        I18NUtil.init();
    }
}

