/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.Table;
import org.anyline.entity.html.Td;
import org.anyline.util.BeanUtil;
import org.dom4j.Element;

public class Tr {
    private Table table;
    private String clazz;
    private List<Td> tds = new ArrayList<Td>();
    private Map<String, String> styles = new HashMap<String, String>();
    private Element src;
    private String widthUnit = "px";

    public Element getSrc() {
        return this.src;
    }

    public void setSrc(Element src) {
        this.src = src;
    }

    public List<Td> getTds() {
        return this.tds;
    }

    public void setTds(List<Td> tds) {
        this.tds = tds;
    }

    public Map<String, String> getStyles() {
        return this.styles;
    }

    public void setStyles(Map<String, String> styles) {
        this.styles = styles;
    }

    public void addStyle(String key, String value) {
        this.styles.put(key, value);
    }

    public Td getTd(int index) {
        return this.tds.get(index);
    }

    public List<Td> getTdsByOffset(int begin) {
        ArrayList<Td> list = new ArrayList<Td>();
        for (Td td : this.tds) {
            if (td.getOffset() + td.getColIndex() < begin) continue;
            list.add(td);
        }
        return list;
    }

    public Tr setTd(int index, Td td) {
        String bg = this.styles.get("background-color");
        if (null != bg) {
            td.getStyles().put("background-color", bg);
        }
        this.tds.add(index, td);
        return this;
    }

    public Tr setHeight(int index, String height) {
        this.styles.put("height", height);
        return this;
    }

    public Tr setHeight(int index, int height) {
        this.styles.put("height", height + this.widthUnit);
        return this;
    }

    public Tr setHeight(int index, double height) {
        this.styles.put("height", height + this.widthUnit);
        return this;
    }

    public Tr addTd(String ... tds) {
        if (null != tds) {
            for (String td : tds) {
                this.addTd(new Td(td));
            }
        }
        return this;
    }

    public Tr addTd(Td td) {
        this.tds.add(td);
        String bg = this.styles.get("background-color");
        if (null != bg) {
            td.getStyles().put("background-color", bg);
        }
        td.setTr(this);
        return this;
    }

    public int index() {
        List<Tr> trs = this.table.getTrs();
        return trs.indexOf(this);
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public Table getTable() {
        return this.table;
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
        for (Td td : this.tds) {
            td.setWidthUnit(widthUnit);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void build(StringBuilder builder) {
        if (null == builder) {
            builder = new StringBuilder();
        }
        builder.append("<tr");
        if (null != this.clazz) {
            builder.append(" class='").append(this.clazz).append("'");
        }
        if (null != this.styles && !this.styles.isEmpty()) {
            builder.append(" style='");
            for (String key : this.styles.keySet()) {
                builder.append(key).append(":").append(this.styles.get(key)).append(";");
            }
            builder.append("'");
        }
        builder.append(">\n");
        for (Td td : this.tds) {
            td.build(builder);
            builder.append("\n");
        }
        builder.append("</tr>");
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        this.build(builder);
        return builder.toString();
    }

    public Tr createCopy(boolean style, boolean content) {
        Tr copy = new Tr();
        copy.setWidthUnit(this.widthUnit);
        int offset = 0;
        for (Td td : this.tds) {
            for (int i = offset; i < td.getOffset(); ++i) {
                copy.addTd(new Td());
                ++offset;
            }
            copy.addTd(td.createCopy(style, content));
        }
        if (style) {
            copy.setClazz(this.clazz);
            List<String> keys = BeanUtil.getMapKeys(this.styles);
            for (String key : keys) {
                copy.addStyle(key, this.styles.get(key));
            }
        }
        return copy;
    }

    public Tr createCopy() {
        return this.createCopy(true, false);
    }
}

