/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.metadata.differ.AbstractDiffer;

public class ColumnsDiffer
extends AbstractDiffer {
    private LinkedHashMap<String, Column> adds = new LinkedHashMap();
    private LinkedHashMap<String, Column> drops = new LinkedHashMap();
    private LinkedHashMap<String, Column> alters = new LinkedHashMap();

    public static ColumnsDiffer compare(LinkedHashMap<String, Column> origins, LinkedHashMap<String, Column> dests, Table direct) {
        ColumnsDiffer differ = new ColumnsDiffer();
        LinkedHashMap<String, Column> adds = new LinkedHashMap<String, Column>();
        LinkedHashMap<String, Column> drops = new LinkedHashMap<String, Column>();
        LinkedHashMap<String, Column> alters = new LinkedHashMap<String, Column>();
        if (null == origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Column origin = origins.get(key);
            Column dest = dests.get(key);
            if (null == dest) {
                drops.put(key, origin);
                continue;
            }
            if (origin.equals(dest)) continue;
            origin.setUpdate(dest, false, false);
            alters.put(key, origin);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.put(key, dests.get(key));
        }
        differ.setDirect(direct);
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setAlters(alters);
        return differ;
    }

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.alters.isEmpty();
    }

    public LinkedHashMap<String, Column> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, Column> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, Column> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, Column> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, Column> getAlters() {
        return this.alters;
    }

    public void setAlters(LinkedHashMap<String, Column> alters) {
        this.alters = alters;
    }
}

