/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Index;
import org.anyline.metadata.Table;
import org.anyline.metadata.differ.AbstractDiffer;

public class IndexesDiffer
extends AbstractDiffer {
    private LinkedHashMap<String, Index> adds = new LinkedHashMap();
    private LinkedHashMap<String, Index> drops = new LinkedHashMap();
    private LinkedHashMap<String, Index> alters = new LinkedHashMap();

    public static IndexesDiffer compare(LinkedHashMap<String, Index> origins, LinkedHashMap<String, Index> dests, Table direct) {
        IndexesDiffer differ = new IndexesDiffer();
        LinkedHashMap<String, Index> adds = new LinkedHashMap<String, Index>();
        LinkedHashMap<String, Index> drops = new LinkedHashMap<String, Index>();
        LinkedHashMap<String, Index> updates = new LinkedHashMap<String, Index>();
        if (null == origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Index<Object> dest;
            Index<Object> origin = origins.get(key);
            if (origin.isPrimary() || null != (dest = dests.get(key)) && dest.isPrimary()) continue;
            if (null == dest) {
                drops.put(key, origins.get(origin));
                continue;
            }
            if (origin.equals(dest) || origin.isPrimary()) continue;
            origin.setUpdate(dest, false, false);
            updates.put(key, origin);
        }
        for (String key : dests.keySet()) {
            Index<Object> index;
            if (origins.containsKey(key) || (index = dests.get(key)).isPrimary()) continue;
            adds.put(key, index);
        }
        differ.setDirect(direct);
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setAlters(updates);
        return differ;
    }

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.alters.isEmpty();
    }

    public LinkedHashMap<String, Index> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, Index> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, Index> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, Index> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, Index> getAlters() {
        return this.alters;
    }

    public void setAlters(LinkedHashMap<String, Index> alters) {
        this.alters = alters;
    }
}

