/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import java.util.LinkedHashMap;
import org.anyline.metadata.Table;
import org.anyline.metadata.differ.AbstractDiffer;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.differ.TableDiffer;

public class TablesDiffer
extends AbstractDiffer {
    private LinkedHashMap<String, Table> adds = new LinkedHashMap();
    private LinkedHashMap<String, Table> drops = new LinkedHashMap();
    private LinkedHashMap<String, Table> alters = new LinkedHashMap();
    private LinkedHashMap<String, TableDiffer> differs = new LinkedHashMap();

    public boolean isEmpty() {
        return this.adds.isEmpty() && this.drops.isEmpty() && this.alters.isEmpty();
    }

    public static TablesDiffer compare(LinkedHashMap<String, Table> origins, LinkedHashMap<String, Table> dests, MetadataDiffer.DIRECT direct) {
        return TablesDiffer.compare(origins, dests, direct, true);
    }

    public static TablesDiffer compare(LinkedHashMap<String, Table> origins, LinkedHashMap<String, Table> dests, boolean ignoreSchema) {
        return TablesDiffer.compare(origins, dests, MetadataDiffer.DIRECT.ORIGIN, ignoreSchema);
    }

    public static TablesDiffer compare(LinkedHashMap<String, Table> origins, LinkedHashMap<String, Table> dests) {
        return TablesDiffer.compare(origins, dests, MetadataDiffer.DIRECT.ORIGIN, true);
    }

    public static TablesDiffer compare(LinkedHashMap<String, Table> origins, LinkedHashMap<String, Table> dests, MetadataDiffer.DIRECT direct, boolean ignoreSchema) {
        TablesDiffer differ = new TablesDiffer();
        LinkedHashMap<String, Table> adds = new LinkedHashMap<String, Table>();
        LinkedHashMap<String, Table> drops = new LinkedHashMap<String, Table>();
        LinkedHashMap<String, Table> alters = new LinkedHashMap<String, Table>();
        LinkedHashMap<String, TableDiffer> differs = new LinkedHashMap<String, TableDiffer>();
        if (null == origins) {
            origins = new LinkedHashMap();
        }
        if (null == dests) {
            dests = new LinkedHashMap();
        }
        for (String key : origins.keySet()) {
            Table<Object> origin = origins.get(key);
            Table<Object> dest = dests.get(key);
            if (null == dest) {
                drops.put(key, origin);
                continue;
            }
            TableDiffer dif = origin.compare(dest, direct);
            if (dif.isEmpty()) continue;
            origin.setUpdate(dest, false, false);
            alters.put(key, origin);
            differs.put(key, dif);
        }
        for (String key : dests.keySet()) {
            if (origins.containsKey(key)) continue;
            adds.put(key, dests.get(key));
        }
        differ.setDirect(direct);
        differ.setAdds(adds);
        differ.setDrops(drops);
        differ.setAlters(alters);
        differ.setDiffers(differs);
        return differ;
    }

    @Override
    public MetadataDiffer setDirect(MetadataDiffer.DIRECT direct) {
        if (null != this.differs) {
            for (TableDiffer differ : this.differs.values()) {
                differ.setDirect(direct);
            }
        }
        return this;
    }

    public LinkedHashMap<String, Table> getAdds() {
        return this.adds;
    }

    public void setAdds(LinkedHashMap<String, Table> adds) {
        this.adds = adds;
    }

    public LinkedHashMap<String, Table> getDrops() {
        return this.drops;
    }

    public void setDrops(LinkedHashMap<String, Table> drops) {
        this.drops = drops;
    }

    public LinkedHashMap<String, Table> getAlters() {
        return this.alters;
    }

    public void setAlters(LinkedHashMap<String, Table> alters) {
        this.alters = alters;
    }

    public LinkedHashMap<String, TableDiffer> getDiffers() {
        return this.differs;
    }

    public void setDiffers(LinkedHashMap<String, TableDiffer> differs) {
        this.differs = differs;
    }
}

