/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.FileUtil;

public class ZipUtil {
    static final Log log = LogProxy.get(ZipUtil.class);
    private static final int BUFF_SIZE = 0x100000;

    public static boolean remove(File zip, String item) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("create", "false");
        URI zip_disk = URI.create("jar:file:/" + zip.getAbsolutePath().replace("\\", "/"));
        try (FileSystem fs = FileSystems.newFileSystem(zip_disk, properties);){
            Path path = fs.getPath(item, new String[0]);
            log.debug("[\u5220\u9664\u538b\u7f29\u6587\u4ef6\u6761\u76ee][zip:{}][item:{}]", (Object)zip.getAbsolutePath(), (Object)path.toUri());
            Files.delete(path);
        }
        catch (Exception e) {
            log.error("remove zip item exception:", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File zip, String item, Charset charset) {
        InputStream in = null;
        ZipFile _zip = null;
        if (!zip.exists()) {
            log.error("[\u6587\u4ef6\u4e0d\u5b58\u5728][path:{}]", (Object)zip.getAbsolutePath());
            return null;
        }
        try {
            String str;
            _zip = new ZipFile(zip);
            ZipEntry _item = _zip.getEntry(item);
            in = _zip.getInputStream(_item);
            String string = str = FileUtil.read(in, charset).toString();
            return string;
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
            String string = null;
            return string;
        }
        finally {
            try {
                _zip.close();
            }
            catch (Exception e) {
                log.error("read zip exception:", e);
            }
        }
    }

    public static InputStream read(File zip, String item) {
        InputStream in = null;
        ZipFile _zip = null;
        if (!zip.exists()) {
            log.error("[\u6587\u4ef6\u4e0d\u5b58\u5728][path:{}]", (Object)zip.getAbsolutePath());
            return null;
        }
        try {
            _zip = new ZipFile(zip);
            ZipEntry _item = _zip.getEntry(item);
            in = _zip.getInputStream(_item);
            return in;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String read(File zip, String item, String charset) {
        return ZipUtil.read(zip, item, Charset.forName(charset));
    }

    public static void replace(File zip, String item, File content) throws Exception {
        ZipUtil.replace(zip, item, new FileInputStream(content));
    }

    public static void replace(File zip, String item, String content) throws Exception {
        ZipUtil.replace(zip, item, content, StandardCharsets.UTF_8);
    }

    public static void replace(File zip, Map<String, String> contents) throws Exception {
        ZipUtil.replace(zip, contents, StandardCharsets.UTF_8);
    }

    public static void replace(File zip, String item, String content, Charset charset) throws Exception {
        ZipUtil.replace(zip, item, new ByteArrayInputStream(content.getBytes(charset)), charset);
    }

    public static void replace(File zip, Map<String, String> contents, Charset charset) throws Exception {
        HashMap<String, InputStream> items = new HashMap<String, InputStream>();
        for (String item : contents.keySet()) {
            items.put(item, new ByteArrayInputStream(contents.get(item).getBytes(charset)));
        }
        ZipUtil.replaces(zip, items, charset);
    }

    public static void replace(File src, String item, InputStream in, Charset charset) throws Exception {
        HashMap<String, InputStream> items = new HashMap<String, InputStream>();
        items.put(item, in);
        ZipUtil.replaces(src, items, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaces(File src, Map<String, InputStream> items, Charset charset) throws Exception {
        if (!src.exists()) {
            log.error("[\u6587\u4ef6\u4e0d\u5b58\u5728][path:{}]", (Object)src.getAbsolutePath());
            return;
        }
        File tempFile = FileUtil.createTempFile(src);
        ZipFile zip = new ZipFile(tempFile, charset);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(src.toPath(), new OpenOption[0]), charset);
        int len = -1;
        byte[] buffer = new byte[8192];
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entity = entries.nextElement();
                String name = entity.getName();
                InputStream is = zip.getInputStream(entity);
                out.putNextEntry(new ZipEntry(name));
                boolean replace = false;
                for (String item : items.keySet()) {
                    if (!item.equals(name)) continue;
                    InputStream in = items.get(item);
                    while ((len = in.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    in.close();
                    replace = true;
                    break;
                }
                if (!replace) {
                    while ((len = is.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                }
                is.close();
            }
        }
        finally {
            out.close();
            zip.close();
            tempFile.delete();
        }
    }

    public static void replace(File src, String item, InputStream in) throws Exception {
        ZipUtil.replace(src, item, in, StandardCharsets.UTF_8);
    }

    public static boolean zip(Map<String, File> files, File zip, String dir, String comment, boolean append) {
        boolean result = true;
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_DEBUG) {
            log.debug("[\u538b\u7f29\u6587\u4ef6][file:{}][size:{}]", (Object)zip.getAbsolutePath(), (Object)files.size());
        }
        try {
            List<String> keys = BeanUtil.getMapKeys(files);
            File parent = zip.getParentFile();
            if (null != parent && !parent.exists()) {
                parent.mkdirs();
            }
            ZipOutputStream zipout = null;
            if (append && zip.exists()) {
                File tempFile = FileUtil.createTempFile(zip);
                byte[] buf = new byte[1024];
                ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));
                zipout = new ZipOutputStream(new FileOutputStream(zip));
                ZipEntry entry = zin.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    boolean notInFiles = true;
                    for (String key : keys) {
                        if (!key.equals(name)) continue;
                        notInFiles = false;
                        break;
                    }
                    if (notInFiles) {
                        int len;
                        zipout.putNextEntry(new ZipEntry(name));
                        while ((len = zin.read(buf)) > 0) {
                            zipout.write(buf, 0, len);
                        }
                    }
                    entry = zin.getNextEntry();
                }
                zin.close();
                tempFile.delete();
            } else {
                zipout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip), 0x100000));
            }
            for (String key : keys) {
                File file = files.get(key);
                if (ZipUtil.zip(file, key, zipout, dir)) continue;
                result = false;
            }
            if (null != comment) {
                zipout.setComment(comment);
            }
            zipout.close();
        }
        catch (Exception e) {
            log.error("zip exception:", e);
        }
        if (ConfigTable.IS_DEBUG) {
            log.debug("[\u538b\u7f29\u5b8c\u6210][time:{}][size:{}]", (Object)(System.currentTimeMillis() - fr), (Object)files.size());
        }
        return result;
    }

    public static boolean zip(Collection<File> files, File zip, String dir, String comment, boolean append) {
        HashMap<String, File> map = new HashMap<String, File>();
        for (File file : files) {
            map.put(file.getName(), file);
        }
        return ZipUtil.zip(map, zip, dir, comment, append);
    }

    public static boolean zip(Collection<File> files, File zip, String dir, String comment) {
        return ZipUtil.zip(files, zip, dir, comment, false);
    }

    public static boolean zip(Map<String, File> files, File zip, String dir, String comment) {
        return ZipUtil.zip(files, zip, dir, comment, false);
    }

    public static boolean append(Collection<File> files, File zip, String dir, String comment) {
        return ZipUtil.zip(files, zip, dir, comment, true);
    }

    public static boolean append(Map<String, File> files, File zip, String dir, String comment) {
        return ZipUtil.zip(files, zip, dir, comment, true);
    }

    public static boolean zip(File item, File zip, String dir, String comment) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(item);
        return ZipUtil.zip(files, zip, dir, comment);
    }

    public static boolean append(File item, File zip, String dir, String comment) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(item);
        return ZipUtil.append(files, zip, dir, comment);
    }

    public static boolean zip(Collection<File> items, File zip, String dir) {
        return ZipUtil.zip(items, zip, dir, null);
    }

    public static boolean zip(Map<String, File> items, File zip, String dir) {
        return ZipUtil.zip(items, zip, dir, null);
    }

    public static boolean append(Collection<File> items, File zip, String dir) {
        return ZipUtil.append(items, zip, dir, null);
    }

    public static boolean append(Map<String, File> items, File zip, String dir) {
        return ZipUtil.append(items, zip, dir, null);
    }

    public static boolean zip(File item, File zip, String dir) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(item);
        return ZipUtil.zip(files, zip, dir);
    }

    public static boolean append(File item, File zip, String dir) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(item);
        return ZipUtil.append(files, zip, dir);
    }

    public static boolean zip(Collection<File> items, File zip) {
        return ZipUtil.zip(items, zip, "");
    }

    public static boolean zip(Map<String, File> items, File zip) {
        return ZipUtil.zip(items, zip, "");
    }

    public static boolean append(Collection<File> items, File zip) {
        return ZipUtil.append(items, zip, "");
    }

    public static boolean append(Map<String, File> items, File zip) {
        return ZipUtil.append(items, zip, "");
    }

    public static boolean zip(File item, File zip) {
        if (item.exists() && item.isDirectory()) {
            String dir = item.getAbsolutePath();
            List<File> files = FileUtil.getAllChildrenFile(item, new String[0]);
            HashMap<String, File> map = new HashMap<String, File>();
            for (File file : files) {
                String path = file.getAbsolutePath();
                String key = path.replace(dir, "");
                map.put(key, file);
            }
            return ZipUtil.zip(map, zip, "", null, false);
        }
        ArrayList<File> files = new ArrayList<File>();
        files.add(item);
        return ZipUtil.zip(files, zip);
    }

    public static boolean append(File item, File zip) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(item);
        return ZipUtil.append(files, zip);
    }

    private static boolean zip(File item, String rename, ZipOutputStream zipout, String dir) {
        try {
            String path = item.getName();
            if (BasicUtil.isNotEmpty(rename)) {
                path = rename;
            }
            if (BasicUtil.isNotEmpty(dir)) {
                path = dir + File.separator + item.getName();
            }
            dir = new String(dir.getBytes("8859_1"), "GB2312");
            if (item.isDirectory()) {
                File[] fileList;
                for (File file : fileList = item.listFiles()) {
                    ZipUtil.zip(file, file.getName(), zipout, path);
                }
            } else {
                int realLength;
                long fr = System.currentTimeMillis();
                byte[] buffer = new byte[0x100000];
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(item), 0x100000);
                zipout.putNextEntry(new ZipEntry(path));
                while ((realLength = in.read(buffer)) != -1) {
                    zipout.write(buffer, 0, realLength);
                }
                in.close();
                zipout.flush();
                zipout.closeEntry();
                if (ConfigTable.IS_DEBUG) {
                    log.debug("[\u538b\u7f29\u6587\u4ef6][\u6dfb\u52a0\u6587\u4ef6][\u8017\u65f6:{}][file:{}]", (Object)DateUtil.format(System.currentTimeMillis() - fr), (Object)item.getAbsolutePath());
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error("zip exception:", e);
            return false;
        }
    }

    public static List<File> unZip(File zip, String dir) {
        return ZipUtil.unZip(zip, new File(dir));
    }

    public static List<File> unZip(File zip, File dir) {
        ArrayList<File> files = new ArrayList<File>();
        long fr = System.currentTimeMillis();
        if (ConfigTable.IS_DEBUG) {
            log.debug("[\u89e3\u538b\u6587\u4ef6][file:{}][dir:{}]", (Object)zip.getAbsolutePath(), (Object)dir.getAbsolutePath());
        }
        int size = 0;
        try {
            if (null != dir && !dir.exists()) {
                dir.mkdirs();
            }
            ZipFile zf = new ZipFile(zip, Charset.forName("GBK"));
            int total = zf.size();
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int realLength;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                ++size;
                InputStream in = zf.getInputStream(entry);
                File desFile = new File(dir, entry.getName());
                if (!desFile.exists()) {
                    File fileParentDir = desFile.getParentFile();
                    if (null != fileParentDir && !fileParentDir.exists()) {
                        fileParentDir.mkdirs();
                    }
                    desFile.createNewFile();
                }
                files.add(desFile);
                FileOutputStream out = new FileOutputStream(desFile);
                byte[] buffer = new byte[0x100000];
                while ((realLength = in.read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, realLength);
                }
                in.close();
                ((OutputStream)out).close();
                if (!ConfigTable.IS_DEBUG) continue;
                log.debug("[\u89e3\u538b\u5b8c\u6210][\u8fdb\u5ea6:{}/{}][\u8017\u65f6:{}][file:{}]", size, total, DateUtil.format(System.currentTimeMillis() - fr), desFile.getAbsolutePath());
            }
            zf.close();
        }
        catch (Exception e) {
            log.error("unzip exception:", e);
        }
        if (ConfigTable.IS_DEBUG) {
            log.debug("[\u89e3\u538b\u5b8c\u6210][\u5171\u8017\u65f6:{}][dir:{}][size:{}]", DateUtil.format(System.currentTimeMillis() - fr), dir.getAbsolutePath(), size);
        }
        return files;
    }

    public static List<File> unZip(File zip) {
        if (null == zip) {
            return new ArrayList<File>();
        }
        return ZipUtil.unZip(zip, zip.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getEntriesNames(File zip) {
        ArrayList<String> entryNames = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                entryNames.add(new String(ZipUtil.getEntryName(entry).getBytes("GB2312"), StandardCharsets.ISO_8859_1));
            }
        }
        catch (Exception e) {
            log.error("check zip exception:", e);
        }
        finally {
            if (null != zipFile) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return entryNames;
    }

    public static String getEntryComment(ZipEntry entry) {
        String result = "";
        try {
            result = entry.getComment();
            if (null != result) {
                result = new String(result.getBytes("GB2312"), "8859_1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getEntryName(ZipEntry entry) {
        String result = "";
        try {
            result = entry.getName();
            if (null != result) {
                result = new String(result.getBytes("GB2312"), "8859_1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<String> items(JarFile jar, String root) {
        ArrayList<String> items = new ArrayList<String>();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryPath = entry.getName();
            if (!entryPath.startsWith(root)) continue;
            items.add(entryPath);
        }
        return items;
    }

    public static List<String> classes(JarFile jar, String pack, boolean inner) {
        ArrayList<String> list = new ArrayList<String>();
        String root = pack.replace(".", "/");
        List<String> items = ZipUtil.items(jar, root);
        for (String item : items) {
            if (!item.endsWith("class") || !inner && item.contains("$")) continue;
            item = item.replace(".class", "").replace("/", ".");
            try {
                list.add(item);
            }
            catch (Exception e) {
                log.warn("[\u7c7b\u52a0\u8f7d\u5931\u8d25][class:{}]", (Object)item);
            }
        }
        return list;
    }
}

