/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.util.List;
import org.anyline.entity.SRS;
import org.anyline.entity.geometry.Point;
import org.anyline.util.BasicUtil;
import org.anyline.util.GISUtil;

public class Coordinate {
    private Point point;
    private Point center;
    private SRS srs;
    private String provinceCode;
    private String provinceName;
    private String cityCode;
    private String cityName;
    private String countyCode;
    private String countyName;
    private String townCode;
    private String townName;
    private String villageCode;
    private String villageName;
    private String street;
    private String streetNumber;
    private List<Double[]> border;
    private String code;
    private int level;
    private String address;
    private boolean success = true;
    private String message = null;
    private int reliability;
    private int accuracy;
    private boolean direct = false;
    private boolean correct = false;

    public Coordinate(String location) {
        String[] tmps;
        if (BasicUtil.isNotEmpty(location) && (tmps = location.split(",")).length > 1) {
            this.point = new Point(BasicUtil.parseDouble(tmps[0], null), BasicUtil.parseDouble(tmps[1], null));
        }
    }

    public Coordinate() {
    }

    public Coordinate(SRS srs, String lng, String lat) {
        this.srs = srs;
        this.point = new Point(BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null));
    }

    public Coordinate(SRS srs, Double lng, Double lat) {
        this.srs = srs;
        this.point = new Point(lng, lat);
    }

    public Coordinate(String lng, String lat) {
        this.point = new Point(BasicUtil.parseDouble(lng, null), BasicUtil.parseDouble(lat, null));
    }

    public Coordinate(Double lng, Double lat) {
        this.point = new Point(lng, lat);
    }

    public Coordinate convert(SRS srs) {
        Double[] loc = GISUtil.convert(this.srs, this.point.x(), this.point.y(), srs);
        this.point = new Point(loc[0], loc[1]);
        this.setSrs(srs);
        return this;
    }

    public boolean isEmpty() {
        return null == this.point || null == this.point.x() || null == this.point.y();
    }

    public void setLocation(String location) {
        String[] tmps;
        if (BasicUtil.isNotEmpty(location) && (tmps = location.split(",")).length > 1) {
            this.point = new Point(BasicUtil.parseDouble(tmps[0], null), BasicUtil.parseDouble(tmps[1], null));
        }
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountyName() {
        return this.countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public String getTownCode() {
        return this.townCode;
    }

    public void setTownCode(String townCode) {
        this.townCode = townCode;
    }

    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public Double getLng() {
        return this.point.x();
    }

    public void setLng(Double lng) {
        if (null == this.point) {
            this.point = new Point();
        }
        this.point.x(lng);
    }

    public void setLng(String lng) {
        this.setLng(BasicUtil.parseDouble(lng, null));
    }

    public Double getLat() {
        return this.point.y();
    }

    public void setLat(Double lat) {
        if (null == this.point) {
            this.point = new Point();
        }
        this.point.y(lat);
    }

    public void setLat(String lat) {
        this.setLat(BasicUtil.parseDouble(lat, null));
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return this.countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {
        return "[" + this.point.x() + "," + this.point.y() + "]";
    }

    public SRS getSrs() {
        return this.srs;
    }

    public void setSrs(SRS srs) {
        this.srs = srs;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public String getVillageCode() {
        return this.villageCode;
    }

    public void setVillageCode(String villageCode) {
        this.villageCode = villageCode;
    }

    public String getVillageName() {
        return this.villageName;
    }

    public void setVillageName(String villageName) {
        this.villageName = villageName;
    }

    public List<Double[]> getBorder() {
        return this.border;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreetNumber() {
        return this.streetNumber;
    }

    public void setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
    }

    public void setBorder(List<Double[]> border) {
        this.border = border;
    }

    public int getReliability() {
        return this.reliability;
    }

    public void setReliability(int reliability) {
        this.reliability = reliability;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public Coordinate correct() {
        if (this.correct) {
            return this;
        }
        String code = BasicUtil.evl(this.getVillageCode(), this.getTownCode(), this.getCountyCode(), this.getCityCode(), this.getProvinceCode());
        if (null == code) {
            return this;
        }
        if (code.startsWith("11") || code.startsWith("12") || code.startsWith("31") || code.startsWith("50")) {
            this.cityCode = this.countyCode;
            this.cityName = this.countyName;
            this.countyCode = this.townCode;
            this.countyName = this.townName;
            this.townCode = this.villageCode;
            this.townName = this.villageName;
            this.correct = true;
        }
        return this;
    }
}

