/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import javax.imageio.ImageIO;
import org.anyline.util.BasicUtil;

public class VerifyCodeUtil {
    public static final String VERIFY_CODES = "3456789ABDEFHJKMNPQRSTUVWXY";
    private static final Random random = new Random();

    public static String getRandomCode(int len) {
        return VerifyCodeUtil.getRandomCode(len, VERIFY_CODES);
    }

    public static String getRandomCode(int verifySize, String sources) {
        if (sources == null || sources.isEmpty()) {
            sources = VERIFY_CODES;
        }
        int codesLen = sources.length();
        Random rand = new Random(System.currentTimeMillis());
        StringBuilder verifyCode = new StringBuilder(verifySize);
        for (int i = 0; i < verifySize; ++i) {
            verifyCode.append(sources.charAt(rand.nextInt(codesLen - 1)));
        }
        return verifyCode.toString();
    }

    public static String outputVerifyImage(int w, int h, File outputFile, int verifySize) throws IOException {
        String verifyCode = VerifyCodeUtil.getRandomCode(verifySize);
        VerifyCodeUtil.outputImage(w, h, outputFile, verifyCode);
        return verifyCode;
    }

    public static String outputVerifyImage(int w, int h, OutputStream os, int verifySize, boolean trouble) throws IOException {
        String verifyCode = VerifyCodeUtil.getRandomCode(verifySize);
        VerifyCodeUtil.outputImage(w, h, os, verifyCode, trouble);
        return verifyCode;
    }

    public static String outputVerifyImage(int w, int h, OutputStream os, int verifySize) throws IOException {
        return VerifyCodeUtil.outputVerifyImage(w, h, os, verifySize, true);
    }

    public static String outputVerifyImageFormula(int w, int h, OutputStream os) throws IOException {
        String[] codes = VerifyCodeUtil.createFormula();
        VerifyCodeUtil.outputImage(w, h, os, codes[0]);
        return codes[1];
    }

    private static String[] createFormula() {
        String[] types = new String[]{"\u52a0", "\u51cf", "\u4e58", "\u9664"};
        int d1 = BasicUtil.getRandomNumber(1, 9);
        int d2 = BasicUtil.getRandomNumber(1, 9);
        int type = d1 % 4;
        if (d1 < d2 && type == 1) {
            type = 0;
        }
        if (d1 % d2 != 0 && type == 3) {
            type = 2;
        }
        String str = d1 + types[type] + d2;
        int cal = d1 + d2;
        if (type == 1) {
            cal = d1 - d2;
        } else if (type == 2) {
            cal = d1 * d2;
        }
        return new String[]{str, "" + cal};
    }

    public static void outputImage(int w, int h, File outputFile, String code) throws IOException {
        if (outputFile == null) {
            return;
        }
        File dir = outputFile.getParentFile();
        if (null != dir && !dir.exists()) {
            dir.mkdirs();
        }
        outputFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(outputFile);
        VerifyCodeUtil.outputImage(w, h, fos, code);
        fos.close();
    }

    public static BufferedImage createImage(String code, int w, int h) {
        return VerifyCodeUtil.createImage(code, w, h, true);
    }

    public static BufferedImage createImage(String code, int w, int h, boolean trouble) {
        int verifySize = code.length();
        BufferedImage image = new BufferedImage(w, h, 1);
        Random rand = new Random();
        Graphics2D g2 = image.createGraphics();
        g2.setFont(new Font("\u5b8b\u4f53", 0, 12));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = new Color[5];
        Color[] colorSpaces = new Color[]{Color.WHITE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW};
        float[] fractions = new float[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colorSpaces[rand.nextInt(colorSpaces.length)];
            fractions[i] = rand.nextFloat();
        }
        Arrays.sort(fractions);
        g2.setColor(Color.GRAY);
        g2.fillRect(0, 0, w, h);
        Color c = VerifyCodeUtil.getRandColor(200, 250);
        g2.setColor(c);
        g2.fillRect(0, 2, w, h - 4);
        if (trouble) {
            VerifyCodeUtil.shear(g2, w, h, c);
        }
        g2.setColor(VerifyCodeUtil.getRandColor(100, 160));
        int fontSize = h - 4;
        Font font = new Font("Algerian", 2, fontSize);
        g2.setFont(font);
        char[] chars = code.toCharArray();
        for (int i = 0; i < verifySize; ++i) {
            g2.setColor(VerifyCodeUtil.getRandColor(0, 160));
            if (trouble) {
                AffineTransform affine = new AffineTransform();
                affine.setToRotation(0.7853981633974483 * rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1), w / verifySize * i + fontSize / 2, h / 2);
                g2.setTransform(affine);
            }
            g2.drawChars(chars, i, 1, (w - 10) / verifySize * i, h / 2 + fontSize / 2 - 5);
        }
        if (trouble) {
            Random random = new Random();
            g2.setColor(VerifyCodeUtil.getRandColor(160, 200));
            for (int i = 0; i < 20; ++i) {
                int x = random.nextInt(w - 1);
                int y = random.nextInt(h - 1);
                int xl = random.nextInt(6) + 1;
                int yl = random.nextInt(12) + 1;
                g2.drawLine(x, y, x + xl + 40, y + yl + 20);
            }
            float yawpRate = 0.1f;
            int area = (int)(yawpRate * (float)w * (float)h);
            for (int i = 0; i < area; ++i) {
                int x = random.nextInt(w);
                int y = random.nextInt(h);
                int rgb = VerifyCodeUtil.getRandomIntColor();
                image.setRGB(x, y, rgb);
            }
        }
        g2.dispose();
        return image;
    }

    public static void outputImage(int w, int h, OutputStream os, String code) throws IOException {
        ImageIO.write((RenderedImage)VerifyCodeUtil.createImage(code, w, h, true), "jpg", os);
    }

    public static void outputImage(int w, int h, OutputStream os, String code, boolean trouble) throws IOException {
        ImageIO.write((RenderedImage)VerifyCodeUtil.createImage(code, w, h, trouble), "jpg", os);
    }

    public static String createBase64(int w, int h, String code, boolean trouble) throws IOException {
        BufferedImage img = VerifyCodeUtil.createImage(code, w, h, trouble);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "jpg", bao);
        byte[] bytes = Base64.getEncoder().encode(bao.toByteArray());
        String base64 = new String(bytes);
        base64 = base64.replaceAll("\n", "").replaceAll("\r", "");
        return "data:image/png;base64," + base64;
    }

    private static Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static int getRandomIntColor() {
        int[] rgb = VerifyCodeUtil.getRandomRgb();
        int color = 0;
        for (int c : rgb) {
            color <<= 8;
            color |= c;
        }
        return color;
    }

    private static int[] getRandomRgb() {
        int[] rgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = random.nextInt(255);
        }
        return rgb;
    }

    private static void shear(Graphics g, int w1, int h1, Color color) {
        VerifyCodeUtil.shearX(g, w1, h1, color);
        VerifyCodeUtil.shearY(g, w1, h1, color);
    }

    private static void shearX(Graphics g, int w1, int h1, Color color) {
        int period = random.nextInt(2);
        boolean borderGap = true;
        boolean frames = true;
        int phase = random.nextInt(2);
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private static void shearY(Graphics g, int w1, int h1, Color color) {
        int period = random.nextInt(40) + 10;
        boolean borderGap = true;
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }
}

