/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util.encrypt;

import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.anyline.util.Base64Util;
import org.anyline.util.BasicUtil;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static Logger log = LoggerFactory.getLogger(AESUtil.class);
    private static final String KEY = "AES";

    public static String encrypt(CIPHER cipher, String password, String content) {
        try {
            Cipher cipherInstance = Cipher.getInstance(cipher.getCode());
            byte[] byteContent = content.getBytes("utf-8");
            cipherInstance.init(1, AESUtil.getSecretKey(password));
            byte[] result = cipherInstance.doFinal(byteContent);
            return Base64.encodeBase64String((byte[])result);
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return null;
        }
    }

    public static String encrypt(String password, String content) {
        return AESUtil.encrypt(CIPHER.PKCS5, password, content);
    }

    public static String decrypt(CIPHER cipher, String password, String vector, String content) {
        try {
            Cipher cipherInstance = Cipher.getInstance(cipher.getCode());
            if (BasicUtil.isNotEmpty(vector)) {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(KEY);
                algorithmParameters.init(new IvParameterSpec(Base64Util.decode(vector)));
                SecretKeySpec key = new SecretKeySpec(Base64Util.decode(password), KEY);
                cipherInstance.init(2, (Key)key, algorithmParameters);
            } else {
                cipherInstance.init(2, AESUtil.getSecretKey(password));
            }
            byte[] result = cipherInstance.doFinal(Base64Util.decode(content));
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            log.error("decrypt exception:", (Throwable)ex);
            return null;
        }
    }

    public static String decrypt(CIPHER cipher, String password, String content) {
        return AESUtil.decrypt(cipher, password, null, content);
    }

    public static String decrypt(String password, String vector, String content) {
        return AESUtil.decrypt(CIPHER.PKCS5, password, vector, content);
    }

    public static String decrypt(String password, String content) {
        return AESUtil.decrypt(CIPHER.PKCS5, password, null, content);
    }

    private static SecretKeySpec getSecretKey(String password) {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(KEY);
            kg.init(128, new SecureRandom(password.getBytes()));
            SecretKey secretKey = kg.generateKey();
            return new SecretKeySpec(secretKey.getEncoded(), KEY);
        }
        catch (Exception ex) {
            log.error("create secret exception:", (Throwable)ex);
            return null;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CIPHER {
        PKCS5{

            @Override
            public String getCode() {
                return "AES/ECB/PKCS5Padding";
            }
        }
        ,
        PKCS7{

            @Override
            public String getCode() {
                return "AES/CBC/PKCS7Padding";
            }
        };


        public abstract String getCode();
    }
}

