/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.postgresql;

import java.util.List;
import org.anyline.entity.geometry.Box;
import org.anyline.entity.geometry.Circle;
import org.anyline.entity.geometry.Line;
import org.anyline.entity.geometry.LineSegment;
import org.anyline.entity.geometry.LineString;
import org.anyline.entity.geometry.Point;
import org.anyline.entity.geometry.Polygon;
import org.anyline.entity.geometry.Ring;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;

public class PostgresqlGeometryAdapter {
    public static Point parsePoint(PGpoint pg) {
        Point point = new Point(Double.valueOf(pg.x), Double.valueOf(pg.y));
        point.origin((Object)pg);
        point.tag("Point");
        return point;
    }

    public static LineSegment parseLineSegment(PGlseg pg) {
        PGpoint[] points = pg.point;
        LineSegment segment = new LineSegment(PostgresqlGeometryAdapter.parsePoint(points[0]), PostgresqlGeometryAdapter.parsePoint(points[1]));
        segment.origin((Object)pg);
        segment.tag("Lseg");
        return segment;
    }

    public static LineString parsePath(PGpath pg) {
        PGpoint[] points;
        LineString string = new LineString();
        for (PGpoint point : points = pg.points) {
            string.add(PostgresqlGeometryAdapter.parsePoint(point));
        }
        string.origin((Object)pg);
        string.tag("Path");
        return string;
    }

    public static Polygon parsePolygon(PGpolygon pg) {
        Polygon polygon = new Polygon();
        PGpoint[] points = pg.points;
        Ring ring = new Ring();
        ring.clockwise(Boolean.valueOf(false));
        for (PGpoint point : points) {
            ring.add(PostgresqlGeometryAdapter.parsePoint(point));
        }
        polygon.add(ring);
        polygon.origin((Object)pg);
        polygon.tag("Polygon");
        return polygon;
    }

    public static Circle parseCircle(PGcircle pg) {
        Circle circle = new Circle(PostgresqlGeometryAdapter.parsePoint(pg.center), pg.radius);
        circle.origin((Object)pg);
        circle.tag("Circle");
        return circle;
    }

    public static Line parseLine(PGline pg) {
        Line line = new Line(pg.a, pg.b, pg.c);
        line.origin((Object)pg);
        line.tag("Line");
        return line;
    }

    public static Box parseBox(PGbox pg) {
        PGpoint[] points = pg.point;
        Box box = new Box(PostgresqlGeometryAdapter.parsePoint(points[0]), PostgresqlGeometryAdapter.parsePoint(points[1]));
        box.origin((Object)pg);
        box.tag("Box");
        return box;
    }

    public static PGpoint convert(Point point) {
        PGpoint pg = new PGpoint(point.x().doubleValue(), point.y().doubleValue());
        return pg;
    }

    public static PGlseg convert(LineSegment segment) {
        PGlseg pg = new PGlseg(PostgresqlGeometryAdapter.convert(segment.p1()), PostgresqlGeometryAdapter.convert(segment.p2()));
        return pg;
    }

    public static PGpath convert(LineString string) {
        List points = string.points();
        if (points.size() > 0) {
            int size = points.size();
            Point first = (Point)points.get(0);
            Point last = (Point)points.get(size - 1);
            boolean open = true;
            if (first.x() == last.x() && first.y() == last.y()) {
                open = false;
            }
            PGpoint[] pgs = new PGpoint[size];
            int index = 0;
            for (Point point : points) {
                pgs[index++] = PostgresqlGeometryAdapter.convert(point);
            }
            PGpath pg = new PGpath(pgs, open);
            return pg;
        }
        return new PGpath();
    }

    public static PGline convert(Line line) {
        PGline pg = new PGline(line.a(), line.b(), line.c());
        return pg;
    }

    public static PGbox convert(Box box) {
        PGbox pg = new PGbox(PostgresqlGeometryAdapter.convert(box.p1()), PostgresqlGeometryAdapter.convert(box.p2()));
        return pg;
    }

    public static PGcircle convert(Circle circle) {
        PGcircle pg = new PGcircle(PostgresqlGeometryAdapter.convert(circle.center()), circle.radius().doubleValue());
        return pg;
    }
}

